
//
// Copyright (C) 2025 voidtools / David Carpenter
// 
// Permission is hereby granted, free of charge, 
// to any person obtaining a copy of this software 
// and associated documentation files (the "Software"), 
// to deal in the Software without restriction, 
// including without limitation the rights to use, 
// copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit 
// persons to whom the Software is furnished to do so, 
// subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be 
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
// IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
// TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
// SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

// property names cannot end with ascending, descending, width or color
// the width column is fine as there is nothing before the word width.
// no columns that start with no that conflict with other properties without the no. eg: noexample == example
	
PROPERTY_NAME_TO_ID_MACRO("0",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_0)
PROPERTY_NAME_TO_ID_MACRO("1",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_1)
PROPERTY_NAME_TO_ID_MACRO("2",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_2)
PROPERTY_NAME_TO_ID_MACRO("3",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_3)
PROPERTY_NAME_TO_ID_MACRO("35mm-focal-length",EVERYTHING3_PROPERTY_ID_35MM_FOCAL_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("4",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_4)
PROPERTY_NAME_TO_ID_MACRO("5",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_5)
PROPERTY_NAME_TO_ID_MACRO("6",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_6)
PROPERTY_NAME_TO_ID_MACRO("7",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_7)
PROPERTY_NAME_TO_ID_MACRO("8",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_8)
PROPERTY_NAME_TO_ID_MACRO("9",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_9)
PROPERTY_NAME_TO_ID_MACRO("a",EVERYTHING3_PROPERTY_ID_COLUMN_A)
PROPERTY_NAME_TO_ID_MACRO("action",EVERYTHING3_PROPERTY_ID_TYPE) // read-journal mode
PROPERTY_NAME_TO_ID_MACRO("ads-ansi",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_ANSI)
PROPERTY_NAME_TO_ID_MACRO("ads-count",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_COUNT)
PROPERTY_NAME_TO_ID_MACRO("ads-hex",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_HEX)
PROPERTY_NAME_TO_ID_MACRO("ads-names",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_NAMES)
PROPERTY_NAME_TO_ID_MACRO("ads-text-plain",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_TEXT_PLAIN)
PROPERTY_NAME_TO_ID_MACRO("ads-utf-16",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_UTF16LE)
PROPERTY_NAME_TO_ID_MACRO("ads-utf-16be",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_UTF16BE)
PROPERTY_NAME_TO_ID_MACRO("ads-utf-8",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_UTF8)
PROPERTY_NAME_TO_ID_MACRO("album",EVERYTHING3_PROPERTY_ID_ALBUM)
PROPERTY_NAME_TO_ID_MACRO("album-artist",EVERYTHING3_PROPERTY_ID_ALBUM_ARTIST)
PROPERTY_NAME_TO_ID_MACRO("alignment-requirement",EVERYTHING3_PROPERTY_ID_ALIGNMENT_REQUIREMENT)
PROPERTY_NAME_TO_ID_MACRO("allocation-size",EVERYTHING3_PROPERTY_ID_ALLOCATION_SIZE)
PROPERTY_NAME_TO_ID_MACRO("alternate-data-stream-ansi",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_ANSI)
PROPERTY_NAME_TO_ID_MACRO("alternate-data-stream-count",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_COUNT)
PROPERTY_NAME_TO_ID_MACRO("alternate-data-stream-hex",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_HEX)
PROPERTY_NAME_TO_ID_MACRO("alternate-data-stream-names",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_NAMES)
PROPERTY_NAME_TO_ID_MACRO("alternate-data-stream-text-plain",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_TEXT_PLAIN)
PROPERTY_NAME_TO_ID_MACRO("alternate-data-stream-utf-16",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_UTF16LE)
PROPERTY_NAME_TO_ID_MACRO("alternate-data-stream-utf-16be",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_UTF16BE)
PROPERTY_NAME_TO_ID_MACRO("alternate-data-stream-utf-8",EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_UTF8)
PROPERTY_NAME_TO_ID_MACRO("altitude",EVERYTHING3_PROPERTY_ID_ALTITUDE)
PROPERTY_NAME_TO_ID_MACRO("aperture",EVERYTHING3_PROPERTY_ID_APERTURE)
PROPERTY_NAME_TO_ID_MACRO("artist",EVERYTHING3_PROPERTY_ID_ARTIST)
PROPERTY_NAME_TO_ID_MACRO("artists",EVERYTHING3_PROPERTY_ID_ARTIST)
PROPERTY_NAME_TO_ID_MACRO("aspect-ratio",EVERYTHING3_PROPERTY_ID_ASPECT_RATIO)
PROPERTY_NAME_TO_ID_MACRO("attr",EVERYTHING3_PROPERTY_ID_ATTRIBUTES)
PROPERTY_NAME_TO_ID_MACRO("attrib",EVERYTHING3_PROPERTY_ID_ATTRIBUTES)
PROPERTY_NAME_TO_ID_MACRO("attribs",EVERYTHING3_PROPERTY_ID_ATTRIBUTES)
PROPERTY_NAME_TO_ID_MACRO("attributes",EVERYTHING3_PROPERTY_ID_ATTRIBUTES)
PROPERTY_NAME_TO_ID_MACRO("audio-bit-rate",EVERYTHING3_PROPERTY_ID_AUDIO_BIT_RATE)
PROPERTY_NAME_TO_ID_MACRO("audio-bits-per-sample",EVERYTHING3_PROPERTY_ID_AUDIO_BITS_PER_SAMPLE)
PROPERTY_NAME_TO_ID_MACRO("audio-channels",EVERYTHING3_PROPERTY_ID_AUDIO_CHANNELS)
PROPERTY_NAME_TO_ID_MACRO("audio-format",EVERYTHING3_PROPERTY_ID_AUDIO_FORMAT)
PROPERTY_NAME_TO_ID_MACRO("audio-sample-rate",EVERYTHING3_PROPERTY_ID_AUDIO_SAMPLE_RATE)
PROPERTY_NAME_TO_ID_MACRO("audio-track-count",EVERYTHING3_PROPERTY_ID_AUDIO_TRACK_COUNT)
PROPERTY_NAME_TO_ID_MACRO("author",EVERYTHING3_PROPERTY_ID_AUTHORS)
PROPERTY_NAME_TO_ID_MACRO("authors",EVERYTHING3_PROPERTY_ID_AUTHORS)
PROPERTY_NAME_TO_ID_MACRO("author-url",EVERYTHING3_PROPERTY_ID_AUTHOR_URL)
PROPERTY_NAME_TO_ID_MACRO("available-free-disk-size",EVERYTHING3_PROPERTY_ID_AVAILABLE_FREE_DISK_SIZE)
PROPERTY_NAME_TO_ID_MACRO("b",EVERYTHING3_PROPERTY_ID_COLUMN_B)
PROPERTY_NAME_TO_ID_MACRO("base-name",EVERYTHING3_PROPERTY_ID_NAME)
PROPERTY_NAME_TO_ID_MACRO("beats-per-minute",EVERYTHING3_PROPERTY_ID_BEATS_PER_MINUTE)
PROPERTY_NAME_TO_ID_MACRO("binary-type",EVERYTHING3_PROPERTY_ID_BINARY_TYPE)
PROPERTY_NAME_TO_ID_MACRO("birth-object-id",EVERYTHING3_PROPERTY_ID_BIRTH_OBJECT_ID)
PROPERTY_NAME_TO_ID_MACRO("birth-volume-id",EVERYTHING3_PROPERTY_ID_BIRTH_VOLUME_ID)
PROPERTY_NAME_TO_ID_MACRO("bit-depth",EVERYTHING3_PROPERTY_ID_BIT_DEPTH)
PROPERTY_NAME_TO_ID_MACRO("bit-rate",EVERYTHING3_PROPERTY_ID_TOTAL_BIT_RATE)
PROPERTY_NAME_TO_ID_MACRO("bom",EVERYTHING3_PROPERTY_ID_BYTE_ORDER_MARK)
PROPERTY_NAME_TO_ID_MACRO("brightness",EVERYTHING3_PROPERTY_ID_BRIGHTNESS)
PROPERTY_NAME_TO_ID_MACRO("byte-offset-for-partition-alignment",EVERYTHING3_PROPERTY_ID_BYTE_OFFSET_FOR_PARTITION_ALIGNMENT)
PROPERTY_NAME_TO_ID_MACRO("byte-offset-for-sector-alignment",EVERYTHING3_PROPERTY_ID_BYTE_OFFSET_FOR_SECTOR_ALIGNMENT)
PROPERTY_NAME_TO_ID_MACRO("byte-order-mark",EVERYTHING3_PROPERTY_ID_BYTE_ORDER_MARK)
PROPERTY_NAME_TO_ID_MACRO("c",EVERYTHING3_PROPERTY_ID_COLUMN_C)
PROPERTY_NAME_TO_ID_MACRO("camera-maker",EVERYTHING3_PROPERTY_ID_CAMERA_MAKER)
PROPERTY_NAME_TO_ID_MACRO("camera-model",EVERYTHING3_PROPERTY_ID_CAMERA_MODEL)
PROPERTY_NAME_TO_ID_MACRO("camera-serial-number",EVERYTHING3_PROPERTY_ID_CAMERA_SERIAL_NUMBER)
PROPERTY_NAME_TO_ID_MACRO("case-sensitive-dir",EVERYTHING3_PROPERTY_ID_CASE_SENSITIVE_DIR)
PROPERTY_NAME_TO_ID_MACRO("category",EVERYTHING3_PROPERTY_ID_CATEGORY)
PROPERTY_NAME_TO_ID_MACRO("change-id",EVERYTHING3_PROPERTY_ID_FILE_ID) // read-journal mode
PROPERTY_NAME_TO_ID_MACRO("character-count",EVERYTHING3_PROPERTY_ID_CHARACTER_COUNT)
PROPERTY_NAME_TO_ID_MACRO("character-encoding",EVERYTHING3_PROPERTY_ID_CHARACTER_ENCODING)
PROPERTY_NAME_TO_ID_MACRO("child-count",EVERYTHING3_PROPERTY_ID_CHILD_COUNT)
PROPERTY_NAME_TO_ID_MACRO("child-count-from-disk",EVERYTHING3_PROPERTY_ID_CHILD_COUNT_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("child-file-count",EVERYTHING3_PROPERTY_ID_CHILD_FILE_COUNT)
PROPERTY_NAME_TO_ID_MACRO("child-file-count-from-disk",EVERYTHING3_PROPERTY_ID_CHILD_FILE_COUNT_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("child-folder-count",EVERYTHING3_PROPERTY_ID_CHILD_FOLDER_COUNT)
PROPERTY_NAME_TO_ID_MACRO("child-folder-count-from-disk",EVERYTHING3_PROPERTY_ID_CHILD_FOLDER_COUNT_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("child-occurrence-count",EVERYTHING3_PROPERTY_ID_CHILD_OCCURRENCE_COUNT)
PROPERTY_NAME_TO_ID_MACRO("cluster-size",EVERYTHING3_PROPERTY_ID_CLUSTER_SIZE)
PROPERTY_NAME_TO_ID_MACRO("col-0",EVERYTHING3_PROPERTY_ID_COLUMN_0)
PROPERTY_NAME_TO_ID_MACRO("col-1",EVERYTHING3_PROPERTY_ID_COLUMN_1)
PROPERTY_NAME_TO_ID_MACRO("col-2",EVERYTHING3_PROPERTY_ID_COLUMN_2)
PROPERTY_NAME_TO_ID_MACRO("col-3",EVERYTHING3_PROPERTY_ID_COLUMN_3)
PROPERTY_NAME_TO_ID_MACRO("col-4",EVERYTHING3_PROPERTY_ID_COLUMN_4)
PROPERTY_NAME_TO_ID_MACRO("col-5",EVERYTHING3_PROPERTY_ID_COLUMN_5)
PROPERTY_NAME_TO_ID_MACRO("col-6",EVERYTHING3_PROPERTY_ID_COLUMN_6)
PROPERTY_NAME_TO_ID_MACRO("col-7",EVERYTHING3_PROPERTY_ID_COLUMN_7)
PROPERTY_NAME_TO_ID_MACRO("col-8",EVERYTHING3_PROPERTY_ID_COLUMN_8)
PROPERTY_NAME_TO_ID_MACRO("col-9",EVERYTHING3_PROPERTY_ID_COLUMN_9)
PROPERTY_NAME_TO_ID_MACRO("col-a",EVERYTHING3_PROPERTY_ID_COLUMN_A)
PROPERTY_NAME_TO_ID_MACRO("col-b",EVERYTHING3_PROPERTY_ID_COLUMN_B)
PROPERTY_NAME_TO_ID_MACRO("col-c",EVERYTHING3_PROPERTY_ID_COLUMN_C)
PROPERTY_NAME_TO_ID_MACRO("col-d",EVERYTHING3_PROPERTY_ID_COLUMN_D)
PROPERTY_NAME_TO_ID_MACRO("col-e",EVERYTHING3_PROPERTY_ID_COLUMN_E)
PROPERTY_NAME_TO_ID_MACRO("col-f",EVERYTHING3_PROPERTY_ID_COLUMN_F)
PROPERTY_NAME_TO_ID_MACRO("color-representation",EVERYTHING3_PROPERTY_ID_COLOR_REPRESENTATION)
PROPERTY_NAME_TO_ID_MACRO("column-0",EVERYTHING3_PROPERTY_ID_COLUMN_0)
PROPERTY_NAME_TO_ID_MACRO("column-1",EVERYTHING3_PROPERTY_ID_COLUMN_1)
PROPERTY_NAME_TO_ID_MACRO("column-2",EVERYTHING3_PROPERTY_ID_COLUMN_2)
PROPERTY_NAME_TO_ID_MACRO("column-3",EVERYTHING3_PROPERTY_ID_COLUMN_3)
PROPERTY_NAME_TO_ID_MACRO("column-4",EVERYTHING3_PROPERTY_ID_COLUMN_4)
PROPERTY_NAME_TO_ID_MACRO("column-5",EVERYTHING3_PROPERTY_ID_COLUMN_5)
PROPERTY_NAME_TO_ID_MACRO("column-6",EVERYTHING3_PROPERTY_ID_COLUMN_6)
PROPERTY_NAME_TO_ID_MACRO("column-7",EVERYTHING3_PROPERTY_ID_COLUMN_7)
PROPERTY_NAME_TO_ID_MACRO("column-8",EVERYTHING3_PROPERTY_ID_COLUMN_8)
PROPERTY_NAME_TO_ID_MACRO("column-9",EVERYTHING3_PROPERTY_ID_COLUMN_9)
PROPERTY_NAME_TO_ID_MACRO("column-a",EVERYTHING3_PROPERTY_ID_COLUMN_A)
PROPERTY_NAME_TO_ID_MACRO("column-b",EVERYTHING3_PROPERTY_ID_COLUMN_B)
PROPERTY_NAME_TO_ID_MACRO("column-c",EVERYTHING3_PROPERTY_ID_COLUMN_C)
PROPERTY_NAME_TO_ID_MACRO("column-d",EVERYTHING3_PROPERTY_ID_COLUMN_D)
PROPERTY_NAME_TO_ID_MACRO("column-e",EVERYTHING3_PROPERTY_ID_COLUMN_E)
PROPERTY_NAME_TO_ID_MACRO("column-f",EVERYTHING3_PROPERTY_ID_COLUMN_F)
PROPERTY_NAME_TO_ID_MACRO("comment",EVERYTHING3_PROPERTY_ID_COMMENT)
PROPERTY_NAME_TO_ID_MACRO("company",EVERYTHING3_PROPERTY_ID_COMPANY)
PROPERTY_NAME_TO_ID_MACRO("composer",EVERYTHING3_PROPERTY_ID_COMPOSER)
PROPERTY_NAME_TO_ID_MACRO("compressed-bits-per-pixel",EVERYTHING3_PROPERTY_ID_COMPRESSED_BITS_PER_PIXEL)
PROPERTY_NAME_TO_ID_MACRO("compressed-size",EVERYTHING3_PROPERTY_ID_COMPRESSED_SIZE)
PROPERTY_NAME_TO_ID_MACRO("compression",EVERYTHING3_PROPERTY_ID_COMPRESSION)
PROPERTY_NAME_TO_ID_MACRO("compression-chunk-shift",EVERYTHING3_PROPERTY_ID_COMPRESSION_CHUNK_SHIFT)
PROPERTY_NAME_TO_ID_MACRO("compression-cluster-shift",EVERYTHING3_PROPERTY_ID_COMPRESSION_CLUSTER_SHIFT)
PROPERTY_NAME_TO_ID_MACRO("compression-format",EVERYTHING3_PROPERTY_ID_COMPRESSION_FORMAT)
PROPERTY_NAME_TO_ID_MACRO("compression-ratio",EVERYTHING3_PROPERTY_ID_COMPRESSION_RATIO)
PROPERTY_NAME_TO_ID_MACRO("compression-unit-shift",EVERYTHING3_PROPERTY_ID_COMPRESSION_UNIT_SHIFT)
PROPERTY_NAME_TO_ID_MACRO("computer",EVERYTHING3_PROPERTY_ID_COMPUTER)
PROPERTY_NAME_TO_ID_MACRO("conductor",EVERYTHING3_PROPERTY_ID_CONDUCTOR)
PROPERTY_NAME_TO_ID_MACRO("container-file-count",EVERYTHING3_PROPERTY_ID_CONTAINER_FILE_COUNT)
PROPERTY_NAME_TO_ID_MACRO("container-filenames",EVERYTHING3_PROPERTY_ID_CONTAINER_FILENAMES)
PROPERTY_NAME_TO_ID_MACRO("content",EVERYTHING3_PROPERTY_ID_CONTENT)
PROPERTY_NAME_TO_ID_MACRO("content-created",EVERYTHING3_PROPERTY_ID_DATE_CONTENT_CREATED)
PROPERTY_NAME_TO_ID_MACRO("content-distributor",EVERYTHING3_PROPERTY_ID_CONTENT_DISTRIBUTOR)
PROPERTY_NAME_TO_ID_MACRO("content-provider",EVERYTHING3_PROPERTY_ID_CONTENT_DISTRIBUTOR)
PROPERTY_NAME_TO_ID_MACRO("content-status",EVERYTHING3_PROPERTY_ID_CONTENT_STATUS)
PROPERTY_NAME_TO_ID_MACRO("content-type",EVERYTHING3_PROPERTY_ID_CONTENT_TYPE)
PROPERTY_NAME_TO_ID_MACRO("contrast",EVERYTHING3_PROPERTY_ID_CONTRAST)
PROPERTY_NAME_TO_ID_MACRO("copyright",EVERYTHING3_PROPERTY_ID_COPYRIGHT)
PROPERTY_NAME_TO_ID_MACRO("crc-32",EVERYTHING3_PROPERTY_ID_CRC32)
PROPERTY_NAME_TO_ID_MACRO("crc-64",EVERYTHING3_PROPERTY_ID_CRC64)
PROPERTY_NAME_TO_ID_MACRO("custom-property-0",EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_0)
PROPERTY_NAME_TO_ID_MACRO("custom-property-1",EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_1)
PROPERTY_NAME_TO_ID_MACRO("custom-property-2",EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_2)
PROPERTY_NAME_TO_ID_MACRO("custom-property-3",EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_3)
PROPERTY_NAME_TO_ID_MACRO("custom-property-4",EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_4)
PROPERTY_NAME_TO_ID_MACRO("custom-property-5",EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_5)
PROPERTY_NAME_TO_ID_MACRO("custom-property-6",EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_6)
PROPERTY_NAME_TO_ID_MACRO("custom-property-7",EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_7)
PROPERTY_NAME_TO_ID_MACRO("custom-property-8",EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_8)
PROPERTY_NAME_TO_ID_MACRO("custom-property-9",EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_9)
PROPERTY_NAME_TO_ID_MACRO("d",EVERYTHING3_PROPERTY_ID_COLUMN_D)
PROPERTY_NAME_TO_ID_MACRO("da",EVERYTHING3_PROPERTY_ID_DATE_ACCESSED)
PROPERTY_NAME_TO_ID_MACRO("da-date",EVERYTHING3_PROPERTY_ID_DATE_ACCESSED_DATE)
PROPERTY_NAME_TO_ID_MACRO("date",EVERYTHING3_PROPERTY_ID_DATE_MODIFIED)
PROPERTY_NAME_TO_ID_MACRO("date-accessed",EVERYTHING3_PROPERTY_ID_DATE_ACCESSED)
PROPERTY_NAME_TO_ID_MACRO("date-accessed-date",EVERYTHING3_PROPERTY_ID_DATE_ACCESSED_DATE)
PROPERTY_NAME_TO_ID_MACRO("date-accessed-time",EVERYTHING3_PROPERTY_ID_DATE_ACCESSED_TIME)
PROPERTY_NAME_TO_ID_MACRO("date-acquired",EVERYTHING3_PROPERTY_ID_DATE_ACQUIRED)
PROPERTY_NAME_TO_ID_MACRO("date-changed",EVERYTHING3_PROPERTY_ID_DATE_CHANGED)
PROPERTY_NAME_TO_ID_MACRO("date-created",EVERYTHING3_PROPERTY_ID_DATE_CREATED)
PROPERTY_NAME_TO_ID_MACRO("date-created-date",EVERYTHING3_PROPERTY_ID_DATE_CREATED_DATE)
PROPERTY_NAME_TO_ID_MACRO("date-created-time",EVERYTHING3_PROPERTY_ID_DATE_CREATED_TIME)
PROPERTY_NAME_TO_ID_MACRO("date-deleted",EVERYTHING3_PROPERTY_ID_DATE_DELETED)
PROPERTY_NAME_TO_ID_MACRO("date-encoded",EVERYTHING3_PROPERTY_ID_DATE_ENCODED)
PROPERTY_NAME_TO_ID_MACRO("date-indexed",EVERYTHING3_PROPERTY_ID_DATE_INDEXED)
PROPERTY_NAME_TO_ID_MACRO("date-media-created",EVERYTHING3_PROPERTY_ID_DATE_ENCODED)
PROPERTY_NAME_TO_ID_MACRO("date-modified",EVERYTHING3_PROPERTY_ID_DATE_MODIFIED)
PROPERTY_NAME_TO_ID_MACRO("date-modified-date",EVERYTHING3_PROPERTY_ID_DATE_MODIFIED_DATE)
PROPERTY_NAME_TO_ID_MACRO("date-modified-time",EVERYTHING3_PROPERTY_ID_DATE_MODIFIED_TIME)
PROPERTY_NAME_TO_ID_MACRO("date-printed",EVERYTHING3_PROPERTY_ID_DATE_PRINTED)
PROPERTY_NAME_TO_ID_MACRO("date-received",EVERYTHING3_PROPERTY_ID_DATE_RECEIVED)
PROPERTY_NAME_TO_ID_MACRO("date-recently-changed",EVERYTHING3_PROPERTY_ID_DATE_RECENTLY_CHANGED)
PROPERTY_NAME_TO_ID_MACRO("date-released",EVERYTHING3_PROPERTY_ID_DATE_RELEASED)
PROPERTY_NAME_TO_ID_MACRO("date-run",EVERYTHING3_PROPERTY_ID_DATE_RUN)
PROPERTY_NAME_TO_ID_MACRO("date-saved",EVERYTHING3_PROPERTY_ID_DATE_SAVED)
PROPERTY_NAME_TO_ID_MACRO("date-sent",EVERYTHING3_PROPERTY_ID_DATE_SENT)
PROPERTY_NAME_TO_ID_MACRO("date-taken",EVERYTHING3_PROPERTY_ID_DATE_TAKEN)
PROPERTY_NAME_TO_ID_MACRO("da-time",EVERYTHING3_PROPERTY_ID_DATE_ACCESSED_TIME)
PROPERTY_NAME_TO_ID_MACRO("day-accessed",EVERYTHING3_PROPERTY_ID_DATE_ACCESSED_DATE)
PROPERTY_NAME_TO_ID_MACRO("day-created",EVERYTHING3_PROPERTY_ID_DATE_CREATED_DATE)
PROPERTY_NAME_TO_ID_MACRO("day-modified",EVERYTHING3_PROPERTY_ID_DATE_MODIFIED_DATE)
PROPERTY_NAME_TO_ID_MACRO("dc",EVERYTHING3_PROPERTY_ID_DATE_CREATED)
PROPERTY_NAME_TO_ID_MACRO("dc-date",EVERYTHING3_PROPERTY_ID_DATE_CREATED_DATE)
PROPERTY_NAME_TO_ID_MACRO("dc-time",EVERYTHING3_PROPERTY_ID_DATE_CREATED_TIME)
PROPERTY_NAME_TO_ID_MACRO("delete-pending",EVERYTHING3_PROPERTY_ID_DELETE_PENDING)
PROPERTY_NAME_TO_ID_MACRO("descendant-count",EVERYTHING3_PROPERTY_ID_DESCENDANT_COUNT)
PROPERTY_NAME_TO_ID_MACRO("descendant-file-count",EVERYTHING3_PROPERTY_ID_DESCENDANT_FILE_COUNT)
PROPERTY_NAME_TO_ID_MACRO("descendant-folder-count",EVERYTHING3_PROPERTY_ID_DESCENDANT_FOLDER_COUNT)
PROPERTY_NAME_TO_ID_MACRO("descendant-occurrence-count",EVERYTHING3_PROPERTY_ID_DESCENDANT_OCCURRENCE_COUNT)
PROPERTY_NAME_TO_ID_MACRO("description",EVERYTHING3_PROPERTY_ID_DESCRIPTION)
PROPERTY_NAME_TO_ID_MACRO("digital-signature-name",EVERYTHING3_PROPERTY_ID_DIGITAL_SIGNATURE_NAME)
PROPERTY_NAME_TO_ID_MACRO("digital-signature-timestamp",EVERYTHING3_PROPERTY_ID_DIGITAL_SIGNATURE_TIMESTAMP)
PROPERTY_NAME_TO_ID_MACRO("digital-zoom",EVERYTHING3_PROPERTY_ID_DIGITAL_ZOOM)
PROPERTY_NAME_TO_ID_MACRO("dimensions",EVERYTHING3_PROPERTY_ID_DIMENSIONS)
PROPERTY_NAME_TO_ID_MACRO("director",EVERYTHING3_PROPERTY_ID_DIRECTORS)
PROPERTY_NAME_TO_ID_MACRO("directors",EVERYTHING3_PROPERTY_ID_DIRECTORS)
PROPERTY_NAME_TO_ID_MACRO("display-filename",EVERYTHING3_PROPERTY_ID_DISPLAY_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("display-full-path",EVERYTHING3_PROPERTY_ID_DISPLAY_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("display-name",EVERYTHING3_PROPERTY_ID_DISPLAY_NAME)
PROPERTY_NAME_TO_ID_MACRO("display-path-and-name",EVERYTHING3_PROPERTY_ID_DISPLAY_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("display-path-name",EVERYTHING3_PROPERTY_ID_DISPLAY_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("dm",EVERYTHING3_PROPERTY_ID_DATE_MODIFIED)
PROPERTY_NAME_TO_ID_MACRO("dm-date",EVERYTHING3_PROPERTY_ID_DATE_MODIFIED_DATE)
PROPERTY_NAME_TO_ID_MACRO("dm-time",EVERYTHING3_PROPERTY_ID_DATE_MODIFIED_TIME)
PROPERTY_NAME_TO_ID_MACRO("document-content-type",EVERYTHING3_PROPERTY_ID_DOCUMENT_CONTENT_TYPE)
PROPERTY_NAME_TO_ID_MACRO("domain-id",EVERYTHING3_PROPERTY_ID_DOMAIN_ID)
PROPERTY_NAME_TO_ID_MACRO("drc",EVERYTHING3_PROPERTY_ID_DATE_RECENTLY_CHANGED)
PROPERTY_NAME_TO_ID_MACRO("drive-type",EVERYTHING3_PROPERTY_ID_DRIVE_TYPE)
PROPERTY_NAME_TO_ID_MACRO("duration",EVERYTHING3_PROPERTY_ID_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("e",EVERYTHING3_PROPERTY_ID_COLUMN_E)
PROPERTY_NAME_TO_ID_MACRO("effective-physical-bytes-per-sector-for-atomicity",EVERYTHING3_PROPERTY_ID_EFFECTIVE_PHYSICAL_BYTES_PER_SECTOR_FOR_ATOMICITY)
PROPERTY_NAME_TO_ID_MACRO("encoded-by",EVERYTHING3_PROPERTY_ID_ENCODED_BY)
PROPERTY_NAME_TO_ID_MACRO("encryption-status",EVERYTHING3_PROPERTY_ID_ENCRYPTION_STATUS)
PROPERTY_NAME_TO_ID_MACRO("end-of-file",EVERYTHING3_PROPERTY_ID_END_OF_FILE)
PROPERTY_NAME_TO_ID_MACRO("exif-version",EVERYTHING3_PROPERTY_ID_EXIF_VERSION)
PROPERTY_NAME_TO_ID_MACRO("exposure-bias",EVERYTHING3_PROPERTY_ID_EXPOSURE_BIAS)
PROPERTY_NAME_TO_ID_MACRO("exposure-program",EVERYTHING3_PROPERTY_ID_EXPOSURE_PROGRAM)
PROPERTY_NAME_TO_ID_MACRO("exposure-time",EVERYTHING3_PROPERTY_ID_EXPOSURE_TIME)
PROPERTY_NAME_TO_ID_MACRO("ext",EVERYTHING3_PROPERTY_ID_EXTENSION)
PROPERTY_NAME_TO_ID_MACRO("extension",EVERYTHING3_PROPERTY_ID_EXTENSION)
PROPERTY_NAME_TO_ID_MACRO("extension-freq",EVERYTHING3_PROPERTY_ID_EXTENSION_FREQUENCY)
PROPERTY_NAME_TO_ID_MACRO("extension-frequency",EVERYTHING3_PROPERTY_ID_EXTENSION_FREQUENCY)
PROPERTY_NAME_TO_ID_MACRO("extension-len",EVERYTHING3_PROPERTY_ID_EXTENSION_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("extension-length",EVERYTHING3_PROPERTY_ID_EXTENSION_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("ext-freq",EVERYTHING3_PROPERTY_ID_EXTENSION_FREQUENCY)
PROPERTY_NAME_TO_ID_MACRO("ext-frequency",EVERYTHING3_PROPERTY_ID_EXTENSION_FREQUENCY)
PROPERTY_NAME_TO_ID_MACRO("ext-len",EVERYTHING3_PROPERTY_ID_EXTENSION_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("ext-length",EVERYTHING3_PROPERTY_ID_EXTENSION_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("f",EVERYTHING3_PROPERTY_ID_COLUMN_F)
PROPERTY_NAME_TO_ID_MACRO("file-id",EVERYTHING3_PROPERTY_ID_FILE_ID)
PROPERTY_NAME_TO_ID_MACRO("file-list-file-name",EVERYTHING3_PROPERTY_ID_FILE_LIST_NAME)
PROPERTY_NAME_TO_ID_MACRO("file-list-full-path",EVERYTHING3_PROPERTY_ID_FILE_LIST_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("file-list-name",EVERYTHING3_PROPERTY_ID_FILE_LIST_NAME)
PROPERTY_NAME_TO_ID_MACRO("file-list-path-and-name",EVERYTHING3_PROPERTY_ID_FILE_LIST_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("file-list-path-name",EVERYTHING3_PROPERTY_ID_FILE_LIST_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("file-name",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("file-name-column",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("file-signature",EVERYTHING3_PROPERTY_ID_FILE_SIGNATURE)
PROPERTY_NAME_TO_ID_MACRO("file-storage-info-flags",EVERYTHING3_PROPERTY_ID_FILE_STORAGE_INFO_FLAGS)
PROPERTY_NAME_TO_ID_MACRO("file-system",EVERYTHING3_PROPERTY_ID_FILE_SYSTEM)
PROPERTY_NAME_TO_ID_MACRO("file-system-flags",EVERYTHING3_PROPERTY_ID_FILE_SYSTEM_FLAGS)
PROPERTY_NAME_TO_ID_MACRO("first-128-bytes",EVERYTHING3_PROPERTY_ID_FIRST_128_BYTES)
PROPERTY_NAME_TO_ID_MACRO("first-16-bytes",EVERYTHING3_PROPERTY_ID_FIRST_16_BYTES)
PROPERTY_NAME_TO_ID_MACRO("first-256-bytes",EVERYTHING3_PROPERTY_ID_FIRST_256_BYTES)
PROPERTY_NAME_TO_ID_MACRO("first-2-bytes",EVERYTHING3_PROPERTY_ID_FIRST_2_BYTES)
PROPERTY_NAME_TO_ID_MACRO("first-32-bytes",EVERYTHING3_PROPERTY_ID_FIRST_32_BYTES)
PROPERTY_NAME_TO_ID_MACRO("first-4-bytes",EVERYTHING3_PROPERTY_ID_FIRST_4_BYTES)
PROPERTY_NAME_TO_ID_MACRO("first-512-bytes",EVERYTHING3_PROPERTY_ID_FIRST_512_BYTES)
PROPERTY_NAME_TO_ID_MACRO("first-64-bytes",EVERYTHING3_PROPERTY_ID_FIRST_64_BYTES)
PROPERTY_NAME_TO_ID_MACRO("first-8-bytes",EVERYTHING3_PROPERTY_ID_FIRST_8_BYTES)
PROPERTY_NAME_TO_ID_MACRO("first-byte",EVERYTHING3_PROPERTY_ID_FIRST_BYTE)
PROPERTY_NAME_TO_ID_MACRO("flash-energy",EVERYTHING3_PROPERTY_ID_FLASH_ENERGY)
PROPERTY_NAME_TO_ID_MACRO("flash-maker",EVERYTHING3_PROPERTY_ID_FLASH_MAKER)
PROPERTY_NAME_TO_ID_MACRO("flash-mode",EVERYTHING3_PROPERTY_ID_FLASH_MODE)
PROPERTY_NAME_TO_ID_MACRO("flash-model",EVERYTHING3_PROPERTY_ID_FLASH_MODEL)
PROPERTY_NAME_TO_ID_MACRO("flfn",EVERYTHING3_PROPERTY_ID_FILE_LIST_NAME)
PROPERTY_NAME_TO_ID_MACRO("focal-length",EVERYTHING3_PROPERTY_ID_FOCAL_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("folder-data-and-names-crc-32",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_CRC32)
PROPERTY_NAME_TO_ID_MACRO("folder-data-and-names-crc-32-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_CRC32_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-data-and-names-crc-64",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_CRC64)
PROPERTY_NAME_TO_ID_MACRO("folder-data-and-names-crc-64-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_CRC64_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-data-and-names-md5",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_MD5)
PROPERTY_NAME_TO_ID_MACRO("folder-data-and-names-md5-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_MD5_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-data-and-names-sha-1",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_SHA1)
PROPERTY_NAME_TO_ID_MACRO("folder-data-and-names-sha-1-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_SHA1_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-data-and-names-sha-256",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_SHA256)
PROPERTY_NAME_TO_ID_MACRO("folder-data-and-names-sha-256-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_SHA256_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-data-and-names-sha-512",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_SHA512)
PROPERTY_NAME_TO_ID_MACRO("folder-data-and-names-sha-512-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_SHA512_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-data-crc-32",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_CRC32)
PROPERTY_NAME_TO_ID_MACRO("folder-data-crc-32-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_CRC32_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-data-crc-64",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_CRC64)
PROPERTY_NAME_TO_ID_MACRO("folder-data-crc-64-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_CRC64_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-data-md5",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_MD5)
PROPERTY_NAME_TO_ID_MACRO("folder-data-md5-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_MD5_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-data-sha-1",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_SHA1)
PROPERTY_NAME_TO_ID_MACRO("folder-data-sha-1-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_SHA1_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-data-sha-256",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_SHA256)
PROPERTY_NAME_TO_ID_MACRO("folder-data-sha-256-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_SHA256_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-data-sha-512",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_SHA512)
PROPERTY_NAME_TO_ID_MACRO("folder-data-sha-512-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_DATA_SHA512_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-depth",EVERYTHING3_PROPERTY_ID_FOLDER_DEPTH)
PROPERTY_NAME_TO_ID_MACRO("folder-names-crc-32",EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_CRC32)
PROPERTY_NAME_TO_ID_MACRO("folder-names-crc-32-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_CRC32_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-names-crc-64",EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_CRC64)
PROPERTY_NAME_TO_ID_MACRO("folder-names-crc-64-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_CRC64_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-names-md5",EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_MD5)
PROPERTY_NAME_TO_ID_MACRO("folder-names-md5-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_MD5_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-names-sha-1",EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_SHA1)
PROPERTY_NAME_TO_ID_MACRO("folder-names-sha-1-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_SHA1_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-names-sha-256",EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_SHA256)
PROPERTY_NAME_TO_ID_MACRO("folder-names-sha-256-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_SHA256_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("folder-names-sha-512",EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_SHA512)
PROPERTY_NAME_TO_ID_MACRO("folder-names-sha-512-from-disk",EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_SHA512_FROM_DISK)
PROPERTY_NAME_TO_ID_MACRO("frame-count",EVERYTHING3_PROPERTY_ID_FRAME_COUNT)
PROPERTY_NAME_TO_ID_MACRO("frame-rate",EVERYTHING3_PROPERTY_ID_FRAME_RATE)
PROPERTY_NAME_TO_ID_MACRO("free-disk-size",EVERYTHING3_PROPERTY_ID_FREE_DISK_SIZE)
PROPERTY_NAME_TO_ID_MACRO("frn",EVERYTHING3_PROPERTY_ID_FILE_ID)
PROPERTY_NAME_TO_ID_MACRO("from",EVERYTHING3_PROPERTY_ID_FROM)
PROPERTY_NAME_TO_ID_MACRO("f-stop",EVERYTHING3_PROPERTY_ID_F_STOP)
PROPERTY_NAME_TO_ID_MACRO("full-path",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("full-path-and-name",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("full-path-len",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("full-path-length",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("full-path-utf-8-byte-length",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME_LENGTH_IN_UTF8_BYTES)
PROPERTY_NAME_TO_ID_MACRO("genre",EVERYTHING3_PROPERTY_ID_GENRE)
PROPERTY_NAME_TO_ID_MACRO("group-description",EVERYTHING3_PROPERTY_ID_CONTENT_GROUP_DESCRIPTION)
PROPERTY_NAME_TO_ID_MACRO("hard-link-count",EVERYTHING3_PROPERTY_ID_HARD_LINK_COUNT)
PROPERTY_NAME_TO_ID_MACRO("hard-link-filenames",EVERYTHING3_PROPERTY_ID_HARD_LINK_FILE_NAMES)
PROPERTY_NAME_TO_ID_MACRO("height",EVERYTHING3_PROPERTY_ID_HEIGHT)
PROPERTY_NAME_TO_ID_MACRO("hidden-slide-count",EVERYTHING3_PROPERTY_ID_HIDDEN_SLIDE_COUNT)
PROPERTY_NAME_TO_ID_MACRO("horizontal-resolution",EVERYTHING3_PROPERTY_ID_HORIZONTAL_RESOLUTION)
PROPERTY_NAME_TO_ID_MACRO("host-url",EVERYTHING3_PROPERTY_ID_HOST_URL)
PROPERTY_NAME_TO_ID_MACRO("icon",EVERYTHING3_PROPERTY_ID_ICON)
PROPERTY_NAME_TO_ID_MACRO("image-id",EVERYTHING3_PROPERTY_ID_IMAGE_ID)
PROPERTY_NAME_TO_ID_MACRO("incur-seek-penalty",EVERYTHING3_PROPERTY_ID_INCUR_SEEK_PENALTY)
PROPERTY_NAME_TO_ID_MACRO("index-number",EVERYTHING3_PROPERTY_ID_INDEX_NUMBER)
PROPERTY_NAME_TO_ID_MACRO("index-type",EVERYTHING3_PROPERTY_ID_INDEX_TYPE)
PROPERTY_NAME_TO_ID_MACRO("initial-key",EVERYTHING3_PROPERTY_ID_INITIAL_KEY)
PROPERTY_NAME_TO_ID_MACRO("is-directory",EVERYTHING3_PROPERTY_ID_IS_DIRECTORY)
PROPERTY_NAME_TO_ID_MACRO("is-folder",EVERYTHING3_PROPERTY_ID_IS_FOLDER)
PROPERTY_NAME_TO_ID_MACRO("iso-speed",EVERYTHING3_PROPERTY_ID_ISO_SPEED)
PROPERTY_NAME_TO_ID_MACRO("journal-id",EVERYTHING3_PROPERTY_ID_PARENT_FILE_ID) // read-journal mode
PROPERTY_NAME_TO_ID_MACRO("keyword",EVERYTHING3_PROPERTY_ID_TAGS)
PROPERTY_NAME_TO_ID_MACRO("keywords",EVERYTHING3_PROPERTY_ID_TAGS)
PROPERTY_NAME_TO_ID_MACRO("kind",EVERYTHING3_PROPERTY_ID_KIND)
PROPERTY_NAME_TO_ID_MACRO("language",EVERYTHING3_PROPERTY_ID_LANGUAGE)
PROPERTY_NAME_TO_ID_MACRO("last-128-bytes",EVERYTHING3_PROPERTY_ID_LAST_128_BYTES)
PROPERTY_NAME_TO_ID_MACRO("last-16-bytes",EVERYTHING3_PROPERTY_ID_LAST_16_BYTES)
PROPERTY_NAME_TO_ID_MACRO("last-256-bytes",EVERYTHING3_PROPERTY_ID_LAST_256_BYTES)
PROPERTY_NAME_TO_ID_MACRO("last-2-bytes",EVERYTHING3_PROPERTY_ID_LAST_2_BYTES)
PROPERTY_NAME_TO_ID_MACRO("last-32-bytes",EVERYTHING3_PROPERTY_ID_LAST_32_BYTES)
PROPERTY_NAME_TO_ID_MACRO("last-4-bytes",EVERYTHING3_PROPERTY_ID_LAST_4_BYTES)
PROPERTY_NAME_TO_ID_MACRO("last-512-bytes",EVERYTHING3_PROPERTY_ID_LAST_512_BYTES)
PROPERTY_NAME_TO_ID_MACRO("last-64-bytes",EVERYTHING3_PROPERTY_ID_LAST_64_BYTES)
PROPERTY_NAME_TO_ID_MACRO("last-8-bytes",EVERYTHING3_PROPERTY_ID_LAST_8_BYTES)
PROPERTY_NAME_TO_ID_MACRO("last-author",EVERYTHING3_PROPERTY_ID_LAST_AUTHOR)
PROPERTY_NAME_TO_ID_MACRO("last-byte",EVERYTHING3_PROPERTY_ID_LAST_BYTE)
PROPERTY_NAME_TO_ID_MACRO("latitude",EVERYTHING3_PROPERTY_ID_LATITUDE)
PROPERTY_NAME_TO_ID_MACRO("len",EVERYTHING3_PROPERTY_ID_NAME_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("length",EVERYTHING3_PROPERTY_ID_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("lens-maker",EVERYTHING3_PROPERTY_ID_LENS_MAKER)
PROPERTY_NAME_TO_ID_MACRO("lens-model",EVERYTHING3_PROPERTY_ID_LENS_MODEL)
PROPERTY_NAME_TO_ID_MACRO("light-source",EVERYTHING3_PROPERTY_ID_LIGHT_SOURCE)
PROPERTY_NAME_TO_ID_MACRO("line-count",EVERYTHING3_PROPERTY_ID_LINE_COUNT)
PROPERTY_NAME_TO_ID_MACRO("links-dirty",EVERYTHING3_PROPERTY_ID_LINKS_DIRTY)
PROPERTY_NAME_TO_ID_MACRO("loc",EVERYTHING3_PROPERTY_ID_PATH)
PROPERTY_NAME_TO_ID_MACRO("location",EVERYTHING3_PROPERTY_ID_PATH)
PROPERTY_NAME_TO_ID_MACRO("logical-bytes-per-sector",EVERYTHING3_PROPERTY_ID_LOGICAL_BYTES_PER_SECTOR)
PROPERTY_NAME_TO_ID_MACRO("long-file-name",EVERYTHING3_PROPERTY_ID_LONG_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("long-full-path",EVERYTHING3_PROPERTY_ID_LONG_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("longitude",EVERYTHING3_PROPERTY_ID_LONGITUDE)
PROPERTY_NAME_TO_ID_MACRO("long-name",EVERYTHING3_PROPERTY_ID_LONG_NAME)
PROPERTY_NAME_TO_ID_MACRO("long-path-and-name",EVERYTHING3_PROPERTY_ID_LONG_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("long-path-name",EVERYTHING3_PROPERTY_ID_LONG_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("machine-target",EVERYTHING3_PROPERTY_ID_TARGET_MACHINE)
PROPERTY_NAME_TO_ID_MACRO("maker-note",EVERYTHING3_PROPERTY_ID_MAKER_NOTE)
PROPERTY_NAME_TO_ID_MACRO("manager",EVERYTHING3_PROPERTY_ID_MANAGER)
PROPERTY_NAME_TO_ID_MACRO("max-aperture",EVERYTHING3_PROPERTY_ID_MAX_APERTURE)
PROPERTY_NAME_TO_ID_MACRO("max-child-depth",EVERYTHING3_PROPERTY_ID_MAX_CHILD_DEPTH)
PROPERTY_NAME_TO_ID_MACRO("maximum-component-length",EVERYTHING3_PROPERTY_ID_MAXIMUM_COMPONENT_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("md5",EVERYTHING3_PROPERTY_ID_MD5)
PROPERTY_NAME_TO_ID_MACRO("md5sum-md5",EVERYTHING3_PROPERTY_ID_MD5SUM_MD5)
PROPERTY_NAME_TO_ID_MACRO("md5sum-pass",EVERYTHING3_PROPERTY_ID_MD5SUM_PASS)
PROPERTY_NAME_TO_ID_MACRO("media-created",EVERYTHING3_PROPERTY_ID_DATE_ENCODED)
PROPERTY_NAME_TO_ID_MACRO("metering-mode",EVERYTHING3_PROPERTY_ID_METERING_MODE)
PROPERTY_NAME_TO_ID_MACRO("mood",EVERYTHING3_PROPERTY_ID_MOOD)
PROPERTY_NAME_TO_ID_MACRO("name",EVERYTHING3_PROPERTY_ID_NAME)
PROPERTY_NAME_TO_ID_MACRO("name-frequency",EVERYTHING3_PROPERTY_ID_NAME_FREQUENCY)
PROPERTY_NAME_TO_ID_MACRO("name-len",EVERYTHING3_PROPERTY_ID_NAME_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("name-length",EVERYTHING3_PROPERTY_ID_NAME_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("name-length-in-utf-8-bytes",EVERYTHING3_PROPERTY_ID_NAME_LENGTH_IN_UTF8_BYTES)
PROPERTY_NAME_TO_ID_MACRO("name-utf-8-byte-length",EVERYTHING3_PROPERTY_ID_NAME_LENGTH_IN_UTF8_BYTES)
PROPERTY_NAME_TO_ID_MACRO("network-index-host",EVERYTHING3_PROPERTY_ID_NETWORK_INDEX_HOST)
PROPERTY_NAME_TO_ID_MACRO("new-filename",EVERYTHING3_PROPERTY_ID_FILE_LIST_PATH_AND_NAME) // read-journal mode
PROPERTY_NAME_TO_ID_MACRO("new-parent-date-modified",EVERYTHING3_PROPERTY_ID_DATE_RUN) // read-journal mode
PROPERTY_NAME_TO_ID_MACRO("note-count",EVERYTHING3_PROPERTY_ID_NOTE_COUNT)
PROPERTY_NAME_TO_ID_MACRO("object-id",EVERYTHING3_PROPERTY_ID_OBJECT_ID)
PROPERTY_NAME_TO_ID_MACRO("offline-availability",EVERYTHING3_PROPERTY_ID_OFFLINE_AVAILABILITY)
PROPERTY_NAME_TO_ID_MACRO("offline-status",EVERYTHING3_PROPERTY_ID_OFFLINE_STATUS)
PROPERTY_NAME_TO_ID_MACRO("online",EVERYTHING3_PROPERTY_ID_INDEX_ONLINE)
PROPERTY_NAME_TO_ID_MACRO("opened-by",EVERYTHING3_PROPERTY_ID_OPENED_BY)
PROPERTY_NAME_TO_ID_MACRO("opens-with",EVERYTHING3_PROPERTY_ID_OPENS_WITH)
PROPERTY_NAME_TO_ID_MACRO("orientation",EVERYTHING3_PROPERTY_ID_ORIENTATION)
PROPERTY_NAME_TO_ID_MACRO("original-filename",EVERYTHING3_PROPERTY_ID_ORIGINAL_FILE_NAME)
PROPERTY_NAME_TO_ID_MACRO("original-location",EVERYTHING3_PROPERTY_ID_ORIGINAL_LOCATION)
PROPERTY_NAME_TO_ID_MACRO("out-of-date",EVERYTHING3_PROPERTY_ID_OUT_OF_DATE)
PROPERTY_NAME_TO_ID_MACRO("owner",EVERYTHING3_PROPERTY_ID_OWNER)
PROPERTY_NAME_TO_ID_MACRO("page-count",EVERYTHING3_PROPERTY_ID_PAGE_COUNT)
PROPERTY_NAME_TO_ID_MACRO("paragraph-count",EVERYTHING3_PROPERTY_ID_PARAGRAPH_COUNT)
PROPERTY_NAME_TO_ID_MACRO("parental-rating",EVERYTHING3_PROPERTY_ID_PARENTAL_RATING)
PROPERTY_NAME_TO_ID_MACRO("parental-rating-reason",EVERYTHING3_PROPERTY_ID_PARENTAL_RATING_REASON)
PROPERTY_NAME_TO_ID_MACRO("parent-date-modified",EVERYTHING3_PROPERTY_ID_DATE_RECENTLY_CHANGED) // read-journal mode
PROPERTY_NAME_TO_ID_MACRO("parent-file-id",EVERYTHING3_PROPERTY_ID_PARENT_FILE_ID)
PROPERTY_NAME_TO_ID_MACRO("parent-name",EVERYTHING3_PROPERTY_ID_PARENT_NAME)
PROPERTY_NAME_TO_ID_MACRO("parent-path",EVERYTHING3_PROPERTY_ID_PARENT_PATH)
PROPERTY_NAME_TO_ID_MACRO("parent-size",EVERYTHING3_PROPERTY_ID_PARENT_SIZE)
PROPERTY_NAME_TO_ID_MACRO("parse-file-name",EVERYTHING3_PROPERTY_ID_PARSE_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("parse-full-path",EVERYTHING3_PROPERTY_ID_PARSE_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("parse-name",EVERYTHING3_PROPERTY_ID_PARSE_NAME)
PROPERTY_NAME_TO_ID_MACRO("parse-path-and-name",EVERYTHING3_PROPERTY_ID_PARSE_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("parse-path-name",EVERYTHING3_PROPERTY_ID_PARSE_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("part-of-a-compilation",EVERYTHING3_PROPERTY_ID_PART_OF_A_COMPILATION)
PROPERTY_NAME_TO_ID_MACRO("part-of-set",EVERYTHING3_PROPERTY_ID_PART_OF_SET)
PROPERTY_NAME_TO_ID_MACRO("path",EVERYTHING3_PROPERTY_ID_PATH)
PROPERTY_NAME_TO_ID_MACRO("path-and-name",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("path-and-name-len",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("path-and-name-length",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("path-and-name-length-in-utf-8-bytes",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME_LENGTH_IN_UTF8_BYTES)
PROPERTY_NAME_TO_ID_MACRO("path-column",EVERYTHING3_PROPERTY_ID_PATH)
PROPERTY_NAME_TO_ID_MACRO("path-len",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("path-length",EVERYTHING3_PROPERTY_ID_PATH_PART_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("path-name",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("path-name-len",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("path-name-length",EVERYTHING3_PROPERTY_ID_PATH_AND_NAME_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("path-part",EVERYTHING3_PROPERTY_ID_PATH)
PROPERTY_NAME_TO_ID_MACRO("people",EVERYTHING3_PROPERTY_ID_PEOPLE)
PROPERTY_NAME_TO_ID_MACRO("perceived-type",EVERYTHING3_PROPERTY_ID_PERCEIVED_TYPE)
PROPERTY_NAME_TO_ID_MACRO("period",EVERYTHING3_PROPERTY_ID_PERIOD)
PROPERTY_NAME_TO_ID_MACRO("photometric-interpretation",EVERYTHING3_PROPERTY_ID_PHOTOMETRIC_INTERPRETATION)
PROPERTY_NAME_TO_ID_MACRO("physical-bytes-per-sector-for-atomicity",EVERYTHING3_PROPERTY_ID_PHYSICAL_BYTES_PER_SECTOR_FOR_ATOMICITY)
PROPERTY_NAME_TO_ID_MACRO("physical-bytes-per-sector-for-performance",EVERYTHING3_PROPERTY_ID_PHYSICAL_BYTES_PER_SECTOR_FOR_PERFORMANCE)
PROPERTY_NAME_TO_ID_MACRO("plain-text-line-count",EVERYTHING3_PROPERTY_ID_PLAIN_TEXT_LINE_COUNT)
PROPERTY_NAME_TO_ID_MACRO("pp",EVERYTHING3_PROPERTY_ID_PATH)
PROPERTY_NAME_TO_ID_MACRO("presentation-format",EVERYTHING3_PROPERTY_ID_PRESENTATION_FORMAT)
PROPERTY_NAME_TO_ID_MACRO("producer",EVERYTHING3_PROPERTY_ID_PRODUCERS)
PROPERTY_NAME_TO_ID_MACRO("producers",EVERYTHING3_PROPERTY_ID_PRODUCERS)
PROPERTY_NAME_TO_ID_MACRO("product-name",EVERYTHING3_PROPERTY_ID_PRODUCT_NAME)
PROPERTY_NAME_TO_ID_MACRO("product-version",EVERYTHING3_PROPERTY_ID_PRODUCT_VERSION)
PROPERTY_NAME_TO_ID_MACRO("promotion-url",EVERYTHING3_PROPERTY_ID_PROMOTION_URL)
PROPERTY_NAME_TO_ID_MACRO("protected",EVERYTHING3_PROPERTY_ID_PROTECTED)
PROPERTY_NAME_TO_ID_MACRO("publisher",EVERYTHING3_PROPERTY_ID_PUBLISHER)
PROPERTY_NAME_TO_ID_MACRO("quicktime-metadata",EVERYTHING3_PROPERTY_ID_QUICKTIME_METADATA)
PROPERTY_NAME_TO_ID_MACRO("rand",EVERYTHING3_PROPERTY_ID_RANDOMIZE)
PROPERTY_NAME_TO_ID_MACRO("random",EVERYTHING3_PROPERTY_ID_RANDOMIZE)
PROPERTY_NAME_TO_ID_MACRO("randomize",EVERYTHING3_PROPERTY_ID_RANDOMIZE)
PROPERTY_NAME_TO_ID_MACRO("rating",EVERYTHING3_PROPERTY_ID_RATING)
PROPERTY_NAME_TO_ID_MACRO("rc",EVERYTHING3_PROPERTY_ID_DATE_RECENTLY_CHANGED)
PROPERTY_NAME_TO_ID_MACRO("recent-change",EVERYTHING3_PROPERTY_ID_DATE_RECENTLY_CHANGED)
PROPERTY_NAME_TO_ID_MACRO("referrer-url",EVERYTHING3_PROPERTY_ID_REFERRER_URL)
PROPERTY_NAME_TO_ID_MACRO("regex-match-0",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_0)
PROPERTY_NAME_TO_ID_MACRO("regex-match-1",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_1)
PROPERTY_NAME_TO_ID_MACRO("regex-match-2",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_2)
PROPERTY_NAME_TO_ID_MACRO("regex-match-3",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_3)
PROPERTY_NAME_TO_ID_MACRO("regex-match-4",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_4)
PROPERTY_NAME_TO_ID_MACRO("regex-match-5",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_5)
PROPERTY_NAME_TO_ID_MACRO("regex-match-6",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_6)
PROPERTY_NAME_TO_ID_MACRO("regex-match-7",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_7)
PROPERTY_NAME_TO_ID_MACRO("regex-match-8",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_8)
PROPERTY_NAME_TO_ID_MACRO("regex-match-9",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_9)
PROPERTY_NAME_TO_ID_MACRO("regex-matches",EVERYTHING3_PROPERTY_ID_REGEX_MATCHES)
PROPERTY_NAME_TO_ID_MACRO("reg-match-0",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_0)
PROPERTY_NAME_TO_ID_MACRO("reg-match-1",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_1)
PROPERTY_NAME_TO_ID_MACRO("reg-match-2",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_2)
PROPERTY_NAME_TO_ID_MACRO("reg-match-3",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_3)
PROPERTY_NAME_TO_ID_MACRO("reg-match-4",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_4)
PROPERTY_NAME_TO_ID_MACRO("reg-match-5",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_5)
PROPERTY_NAME_TO_ID_MACRO("reg-match-6",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_6)
PROPERTY_NAME_TO_ID_MACRO("reg-match-7",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_7)
PROPERTY_NAME_TO_ID_MACRO("reg-match-8",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_8)
PROPERTY_NAME_TO_ID_MACRO("reg-match-9",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_9)
PROPERTY_NAME_TO_ID_MACRO("reg-matches",EVERYTHING3_PROPERTY_ID_REGEX_MATCHES)
PROPERTY_NAME_TO_ID_MACRO("regular-expression-match-0",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_0)
PROPERTY_NAME_TO_ID_MACRO("regular-expression-match-1",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_1)
PROPERTY_NAME_TO_ID_MACRO("regular-expression-match-2",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_2)
PROPERTY_NAME_TO_ID_MACRO("regular-expression-match-3",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_3)
PROPERTY_NAME_TO_ID_MACRO("regular-expression-match-4",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_4)
PROPERTY_NAME_TO_ID_MACRO("regular-expression-match-5",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_5)
PROPERTY_NAME_TO_ID_MACRO("regular-expression-match-6",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_6)
PROPERTY_NAME_TO_ID_MACRO("regular-expression-match-7",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_7)
PROPERTY_NAME_TO_ID_MACRO("regular-expression-match-8",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_8)
PROPERTY_NAME_TO_ID_MACRO("regular-expression-match-9",EVERYTHING3_PROPERTY_ID_REGEX_MATCH_9)
PROPERTY_NAME_TO_ID_MACRO("regular-expression-matches-1-9",EVERYTHING3_PROPERTY_ID_REGEX_MATCHES)
PROPERTY_NAME_TO_ID_MACRO("related-sound-file",EVERYTHING3_PROPERTY_ID_RELATED_SOUND_FILE)
PROPERTY_NAME_TO_ID_MACRO("remote-protocol",EVERYTHING3_PROPERTY_ID_REMOTE_PROTOCOL)
PROPERTY_NAME_TO_ID_MACRO("remote-protocol-flags",EVERYTHING3_PROPERTY_ID_REMOTE_PROTOCOL_FLAGS)
PROPERTY_NAME_TO_ID_MACRO("remote-protocol-version",EVERYTHING3_PROPERTY_ID_REMOTE_PROTOCOL_VERSION)
PROPERTY_NAME_TO_ID_MACRO("reparse-tag",EVERYTHING3_PROPERTY_ID_REPARSE_TAG)
PROPERTY_NAME_TO_ID_MACRO("reparse-target",EVERYTHING3_PROPERTY_ID_REPARSE_TARGET)
PROPERTY_NAME_TO_ID_MACRO("resolution-unit",EVERYTHING3_PROPERTY_ID_RESOLUTION_UNIT)
PROPERTY_NAME_TO_ID_MACRO("revision-number",EVERYTHING3_PROPERTY_ID_REVISION_NUMBER)
PROPERTY_NAME_TO_ID_MACRO("root-name",EVERYTHING3_PROPERTY_ID_ROOT_NAME)
PROPERTY_NAME_TO_ID_MACRO("root-size",EVERYTHING3_PROPERTY_ID_ROOT_SIZE)
PROPERTY_NAME_TO_ID_MACRO("row",EVERYTHING3_PROPERTY_ID_ROW)
PROPERTY_NAME_TO_ID_MACRO("run-count",EVERYTHING3_PROPERTY_ID_RUN_COUNT)
PROPERTY_NAME_TO_ID_MACRO("saturation",EVERYTHING3_PROPERTY_ID_SATURATION)
PROPERTY_NAME_TO_ID_MACRO("scale",EVERYTHING3_PROPERTY_ID_SCALE)
PROPERTY_NAME_TO_ID_MACRO("sector-size",EVERYTHING3_PROPERTY_ID_SECTOR_SIZE)
PROPERTY_NAME_TO_ID_MACRO("sfv-crc-32",EVERYTHING3_PROPERTY_ID_SFV_CRC32)
PROPERTY_NAME_TO_ID_MACRO("sfv-pass",EVERYTHING3_PROPERTY_ID_SFV_PASS)
PROPERTY_NAME_TO_ID_MACRO("sha-1",EVERYTHING3_PROPERTY_ID_SHA1)
PROPERTY_NAME_TO_ID_MACRO("sha1sum-pass",EVERYTHING3_PROPERTY_ID_SHA1SUM_PASS)
PROPERTY_NAME_TO_ID_MACRO("sha1sum-sha-1",EVERYTHING3_PROPERTY_ID_SHA1SUM_SHA1)
PROPERTY_NAME_TO_ID_MACRO("sha-256",EVERYTHING3_PROPERTY_ID_SHA256)
PROPERTY_NAME_TO_ID_MACRO("sha256sum-pass",EVERYTHING3_PROPERTY_ID_SHA256SUM_PASS)
PROPERTY_NAME_TO_ID_MACRO("sha256sum-sha-256",EVERYTHING3_PROPERTY_ID_SHA256SUM_SHA256)
PROPERTY_NAME_TO_ID_MACRO("sha-384",EVERYTHING3_PROPERTY_ID_SHA384)
PROPERTY_NAME_TO_ID_MACRO("sha-512",EVERYTHING3_PROPERTY_ID_SHA512)
PROPERTY_NAME_TO_ID_MACRO("sha512sum-pass",EVERYTHING3_PROPERTY_ID_SHA512SUM_PASS)
PROPERTY_NAME_TO_ID_MACRO("sha512sum-sha-512",EVERYTHING3_PROPERTY_ID_SHA512SUM_SHA512)
PROPERTY_NAME_TO_ID_MACRO("shared-with",EVERYTHING3_PROPERTY_ID_SHARED_WITH)
PROPERTY_NAME_TO_ID_MACRO("sharpness",EVERYTHING3_PROPERTY_ID_SHARPNESS)
PROPERTY_NAME_TO_ID_MACRO("shell-attributes",EVERYTHING3_PROPERTY_ID_SHELL_ATTRIBUTES)
PROPERTY_NAME_TO_ID_MACRO("shortcut-target",EVERYTHING3_PROPERTY_ID_SHORTCUT_TARGET)
PROPERTY_NAME_TO_ID_MACRO("short-file-name",EVERYTHING3_PROPERTY_ID_SHORT_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("short-full-path",EVERYTHING3_PROPERTY_ID_SHORT_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("short-name",EVERYTHING3_PROPERTY_ID_SHORT_NAME)
PROPERTY_NAME_TO_ID_MACRO("short-path-and-name",EVERYTHING3_PROPERTY_ID_SHORT_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("short-path-name",EVERYTHING3_PROPERTY_ID_SHORT_PATH_AND_NAME)
PROPERTY_NAME_TO_ID_MACRO("shutter-speed",EVERYTHING3_PROPERTY_ID_SHUTTER_SPEED)
PROPERTY_NAME_TO_ID_MACRO("sibling-count",EVERYTHING3_PROPERTY_ID_SIBLING_COUNT)
PROPERTY_NAME_TO_ID_MACRO("sibling-file-count",EVERYTHING3_PROPERTY_ID_SIBLING_FILE_COUNT)
PROPERTY_NAME_TO_ID_MACRO("sibling-folder-count",EVERYTHING3_PROPERTY_ID_SIBLING_FOLDER_COUNT)
PROPERTY_NAME_TO_ID_MACRO("size",EVERYTHING3_PROPERTY_ID_SIZE)
PROPERTY_NAME_TO_ID_MACRO("size-frequency",EVERYTHING3_PROPERTY_ID_SIZE_FREQUENCY)
PROPERTY_NAME_TO_ID_MACRO("size-on-disk",EVERYTHING3_PROPERTY_ID_SIZE_ON_DISK)
PROPERTY_NAME_TO_ID_MACRO("slide-count",EVERYTHING3_PROPERTY_ID_SLIDE_COUNT)
PROPERTY_NAME_TO_ID_MACRO("software",EVERYTHING3_PROPERTY_ID_SOFTWARE)
PROPERTY_NAME_TO_ID_MACRO("source-date-changed",EVERYTHING3_PROPERTY_ID_DATE_INDEXED) // read-journal mode
PROPERTY_NAME_TO_ID_MACRO("status",EVERYTHING3_PROPERTY_ID_STATUS)
PROPERTY_NAME_TO_ID_MACRO("stem",EVERYTHING3_PROPERTY_ID_STEM)
PROPERTY_NAME_TO_ID_MACRO("stem-length",EVERYTHING3_PROPERTY_ID_STEM_LENGTH)
PROPERTY_NAME_TO_ID_MACRO("subject",EVERYTHING3_PROPERTY_ID_SUBJECT)
PROPERTY_NAME_TO_ID_MACRO("subject-distance",EVERYTHING3_PROPERTY_ID_SUBJECT_DISTANCE)
PROPERTY_NAME_TO_ID_MACRO("subtitle",EVERYTHING3_PROPERTY_ID_SUBTITLE)
PROPERTY_NAME_TO_ID_MACRO("subtitle-track-count",EVERYTHING3_PROPERTY_ID_SUBTITLE_TRACK_COUNT)
PROPERTY_NAME_TO_ID_MACRO("sz",EVERYTHING3_PROPERTY_ID_SIZE)
PROPERTY_NAME_TO_ID_MACRO("tag",EVERYTHING3_PROPERTY_ID_TAGS)
PROPERTY_NAME_TO_ID_MACRO("tags",EVERYTHING3_PROPERTY_ID_TAGS)
PROPERTY_NAME_TO_ID_MACRO("target-machine",EVERYTHING3_PROPERTY_ID_TARGET_MACHINE)
PROPERTY_NAME_TO_ID_MACRO("template",EVERYTHING3_PROPERTY_ID_TEMPLATE)
PROPERTY_NAME_TO_ID_MACRO("text-plain-line-count",EVERYTHING3_PROPERTY_ID_PLAIN_TEXT_LINE_COUNT)
PROPERTY_NAME_TO_ID_MACRO("thumbnail",EVERYTHING3_PROPERTY_ID_THUMBNAIL)
PROPERTY_NAME_TO_ID_MACRO("time-accessed",EVERYTHING3_PROPERTY_ID_DATE_ACCESSED_TIME)
PROPERTY_NAME_TO_ID_MACRO("time-created",EVERYTHING3_PROPERTY_ID_DATE_CREATED_TIME)
PROPERTY_NAME_TO_ID_MACRO("time-modified",EVERYTHING3_PROPERTY_ID_DATE_MODIFIED_TIME)
PROPERTY_NAME_TO_ID_MACRO("title",EVERYTHING3_PROPERTY_ID_TITLE)
PROPERTY_NAME_TO_ID_MACRO("to",EVERYTHING3_PROPERTY_ID_TO)
PROPERTY_NAME_TO_ID_MACRO("total-alternate-data-stream-size",EVERYTHING3_PROPERTY_ID_TOTAL_ALTERNATE_DATA_STREAM_SIZE)
PROPERTY_NAME_TO_ID_MACRO("total-alternate-data-stream-size-on-disk",EVERYTHING3_PROPERTY_ID_TOTAL_ALTERNATE_DATA_STREAM_SIZE_ON_DISK)
PROPERTY_NAME_TO_ID_MACRO("total-bit-rate",EVERYTHING3_PROPERTY_ID_TOTAL_BIT_RATE)
PROPERTY_NAME_TO_ID_MACRO("total-child-size",EVERYTHING3_PROPERTY_ID_TOTAL_CHILD_SIZE)
PROPERTY_NAME_TO_ID_MACRO("total-disk-size",EVERYTHING3_PROPERTY_ID_TOTAL_DISK_SIZE)
PROPERTY_NAME_TO_ID_MACRO("total-editing-time",EVERYTHING3_PROPERTY_ID_TOTAL_EDITING_TIME)
PROPERTY_NAME_TO_ID_MACRO("total-size",EVERYTHING3_PROPERTY_ID_TOTAL_SIZE)
PROPERTY_NAME_TO_ID_MACRO("total-size-on-disk",EVERYTHING3_PROPERTY_ID_TOTAL_SIZE_ON_DISK)
PROPERTY_NAME_TO_ID_MACRO("track",EVERYTHING3_PROPERTY_ID_TRACK)
PROPERTY_NAME_TO_ID_MACRO("trademark",EVERYTHING3_PROPERTY_ID_TRADEMARKS)
PROPERTY_NAME_TO_ID_MACRO("trademarks",EVERYTHING3_PROPERTY_ID_TRADEMARKS)
PROPERTY_NAME_TO_ID_MACRO("transcoded-for-sync",EVERYTHING3_PROPERTY_ID_TRANSCODED_FOR_SYNC)
PROPERTY_NAME_TO_ID_MACRO("type",EVERYTHING3_PROPERTY_ID_TYPE)
PROPERTY_NAME_TO_ID_MACRO("url",EVERYTHING3_PROPERTY_ID_URL)
PROPERTY_NAME_TO_ID_MACRO("used-disk-size",EVERYTHING3_PROPERTY_ID_USED_DISK_SIZE)
PROPERTY_NAME_TO_ID_MACRO("valid-utf-8",EVERYTHING3_PROPERTY_ID_VALID_UTF8)
PROPERTY_NAME_TO_ID_MACRO("version",EVERYTHING3_PROPERTY_ID_VERSION)
PROPERTY_NAME_TO_ID_MACRO("version-number",EVERYTHING3_PROPERTY_ID_VERSION_NUMBER)
PROPERTY_NAME_TO_ID_MACRO("vertical-resolution",EVERYTHING3_PROPERTY_ID_VERTICAL_RESOLUTION)
PROPERTY_NAME_TO_ID_MACRO("video-bit-rate",EVERYTHING3_PROPERTY_ID_VIDEO_BIT_RATE)
PROPERTY_NAME_TO_ID_MACRO("video-format",EVERYTHING3_PROPERTY_ID_VIDEO_FORMAT)
PROPERTY_NAME_TO_ID_MACRO("video-track-count",EVERYTHING3_PROPERTY_ID_VIDEO_TRACK_COUNT)
PROPERTY_NAME_TO_ID_MACRO("volume-label",EVERYTHING3_PROPERTY_ID_VOLUME_LABEL)
PROPERTY_NAME_TO_ID_MACRO("volume-name",EVERYTHING3_PROPERTY_ID_VOLUME_NAME)
PROPERTY_NAME_TO_ID_MACRO("volume-path",EVERYTHING3_PROPERTY_ID_VOLUME_PATH)
PROPERTY_NAME_TO_ID_MACRO("volume-serial-number",EVERYTHING3_PROPERTY_ID_VOLUME_SERIAL_NUMBER)
PROPERTY_NAME_TO_ID_MACRO("vorbis-comment",EVERYTHING3_PROPERTY_ID_VORBIS_COMMENT)
PROPERTY_NAME_TO_ID_MACRO("white-balance",EVERYTHING3_PROPERTY_ID_WHITE_BALANCE)
PROPERTY_NAME_TO_ID_MACRO("width",EVERYTHING3_PROPERTY_ID_WIDTH)
PROPERTY_NAME_TO_ID_MACRO("word-count",EVERYTHING3_PROPERTY_ID_WORD_COUNT)
PROPERTY_NAME_TO_ID_MACRO("writer",EVERYTHING3_PROPERTY_ID_WRITERS)
PROPERTY_NAME_TO_ID_MACRO("writers",EVERYTHING3_PROPERTY_ID_WRITERS)
PROPERTY_NAME_TO_ID_MACRO("year",EVERYTHING3_PROPERTY_ID_YEAR)
PROPERTY_NAME_TO_ID_MACRO("zone-id",EVERYTHING3_PROPERTY_ID_ZONE_ID)
