
//
// Copyright (C) 2025 voidtools / David Carpenter
// 
// Permission is hereby granted, free of charge, 
// to any person obtaining a copy of this software 
// and associated documentation files (the "Software"), 
// to deal in the Software without restriction, 
// including without limitation the rights to use, 
// copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit 
// persons to whom the Software is furnished to do so, 
// subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be 
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
// IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
// TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
// SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

#define POOL_STACK_SIZE				256
#define POOL_MAX_CHUNK_SIZE			65536

#define POOL_CHUNK_DATA(chunk)		((BYTE *)(((pool_chunk_t *)(chunk)) + 1))

// a chunk of memory.
typedef struct pool_chunk_s
{
	union
	{
		// the next pool in the list.
		struct pool_chunk_s *next;
		
		// ensure 8-byte alignment.
		ES_UINT64 alignment;
	};
	
	// data follows.
	// BYTE data[];
	
}pool_chunk_t;

// a simple pool bump allocator
typedef struct pool_s
{
	// current position
	BYTE *p;
	
	// bytes available at position
	SIZE_T avail;
	
	// chunk list.
	pool_chunk_t *chunk_start;
	
	// current chunk size.
	SIZE_T cur_alloc_size;
	
	// some stack space.
	// make sure this is 16-byte aligned.
	BYTE stack[POOL_STACK_SIZE];
	
}pool_t;

void pool_init(pool_t *buf);
void pool_empty(pool_t *buf);
void pool_kill(pool_t *buf);
void *pool_alloc(pool_t *buf,SIZE_T size);
