
//
// Copyright (C) 2025 voidtools / David Carpenter
// 
// Permission is hereby granted, free of charge, 
// to any person obtaining a copy of this software 
// and associated documentation files (the "Software"), 
// to deal in the Software without restriction, 
// including without limitation the rights to use, 
// copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit 
// persons to whom the Software is furnished to do so, 
// subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be 
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
// IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
// TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
// SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

#ifndef _EVERYTHING3_H_
#define _EVERYTHING3_H_

#ifdef __cplusplus
extern "C" {
#endif

// types
#ifndef EVERYTHING3_BYTE
#define EVERYTHING3_BYTE		BYTE
#endif

#ifndef EVERYTHING3_CHAR
#define EVERYTHING3_CHAR		CHAR
#endif

#ifndef EVERYTHING3_WORD
#define EVERYTHING3_WORD		WORD
#endif

#ifndef EVERYTHING3_DWORD
#define EVERYTHING3_DWORD		DWORD
#endif

#ifndef EVERYTHING3_INT32
#define EVERYTHING3_INT32		__int32
#endif

#ifndef EVERYTHING3_UINT64
#define EVERYTHING3_UINT64		unsigned __int64
#endif

#ifndef EVERYTHING3_SIZE_T
#define EVERYTHING3_SIZE_T		SIZE_T
#endif

#ifndef EVERYTHING3_BOOL
#define EVERYTHING3_BOOL		BOOL
#endif

#ifndef EVERYTHING3_WCHAR
#define EVERYTHING3_WCHAR		WCHAR
#endif

// define EVERYTHING3_USERAPI if you are using the static LIB.
#ifndef EVERYTHING3_USERAPI
#define EVERYTHING3_USERAPI		__declspec(dllimport)
#endif

#define EVERYTHING3_BYTE_MAX								0xff
#define EVERYTHING3_WORD_MAX								0xffff
#define EVERYTHING3_DWORD_MAX								0xffffffff
#define EVERYTHING3_UINT64_MAX								0xffffffffffffffffUI64
#define EVERYTHING3_INT32_MIN								(-2147483647 - 1)

// Everything3_GetLastError()
#define EVERYTHING3_OK										0 // no error detected
#define EVERYTHING3_ERROR_OUT_OF_MEMORY						0xE0000001 // out of memory.
#define EVERYTHING3_ERROR_IPC_PIPE_NOT_FOUND				0xE0000002 // IPC pipe server not found (Everything search client is not running)
#define EVERYTHING3_ERROR_DISCONNECTED						0xE0000003 // disconnected from pipe server
#define EVERYTHING3_ERROR_INVALID_PARAMETER					0xE0000004 // invalid parameter
#define EVERYTHING3_ERROR_BAD_REQUEST						0xE0000005 // bad request
#define EVERYTHING3_ERROR_CANCELLED							0xE0000006 // user cancelled
#define EVERYTHING3_ERROR_PROPERTY_NOT_FOUND				0xE0000007 // property not found
#define EVERYTHING3_ERROR_SERVER							0xE0000008 // server error (server out of memory)
#define EVERYTHING3_ERROR_INVALID_COMMAND					0xE0000009 // invalid command
#define EVERYTHING3_ERROR_BAD_RESPONSE						0xE000000A // bad server response
#define EVERYTHING3_ERROR_INSUFFICIENT_BUFFER				0xE000000B // not enough room to store response data
#define EVERYTHING3_ERROR_SHUTDOWN							0xE000000C // shutdown initiated by user
#define EVERYTHING3_ERROR_INVALID_PROPERTY_VALUE_TYPE		0xE000000D // property value type is incorrect.

// Everything_GetTargetMachine()
#define EVERYTHING3_TARGET_MACHINE_UNKNOWN					0
#define EVERYTHING3_TARGET_MACHINE_X86						1
#define EVERYTHING3_TARGET_MACHINE_X64						2
#define EVERYTHING3_TARGET_MACHINE_ARM						3
#define EVERYTHING3_TARGET_MACHINE_ARM64					4

#ifndef EVERYTHING3_API
#define EVERYTHING3_API __stdcall
#endif

// Everything3_SetSearchFoldersFirst() / Everything3_GetSearchFoldersFirst()
#define EVERYTHING3_SEARCH_FOLDERS_FIRST_ASCENDING			0 // folders first when sort ascending
#define EVERYTHING3_SEARCH_FOLDERS_FIRST_ALWAYS				1 // folders first
#define EVERYTHING3_SEARCH_FOLDERS_FIRST_NEVER				2 // folders last 
#define EVERYTHING3_SEARCH_FOLDERS_FIRST_DESCENDING			3 // folders first when sort descending

// Everything3_GetPropertyType()
#define EVERYTHING3_PROPERTY_TYPE_NONE						0
#define EVERYTHING3_PROPERTY_TYPE_METADATA					1
#define EVERYTHING3_PROPERTY_TYPE_FILE						2
#define EVERYTHING3_PROPERTY_TYPE_INDEX						3
#define EVERYTHING3_PROPERTY_TYPE_CONTENT					4
#define EVERYTHING3_PROPERTY_TYPE_VOLUME					5
#define EVERYTHING3_PROPERTY_TYPE_SEARCH					6
#define EVERYTHING3_PROPERTY_TYPE_PROPERTY_SYSTEM			7

// Property IDs
// These will not change.
// The value type will not change.
#define EVERYTHING3_INVALID_PROPERTY_ID						0xffffffff
#define EVERYTHING3_PROPERTY_ID_NAME						0 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_PATH						1 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_FOLDER_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_SIZE						2 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_EXTENSION					3 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_TYPE						4 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_DATE_MODIFIED				5 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_DATE_CREATED				6 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_DATE_ACCESSED				7 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_ATTRIBUTES					8 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_DATE_RECENTLY_CHANGED		9 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_RUN_COUNT					10 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_DATE_RUN					11 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_FILE_LIST_NAME				12 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_WIDTH						13 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_HEIGHT						14 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_DIMENSIONS					15 // EVERYTHING3_PROPERTY_VALUE_TYPE_DIMENSIONS,
#define EVERYTHING3_PROPERTY_ID_ASPECT_RATIO				16 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD_FIXED_Q1K,
#define EVERYTHING3_PROPERTY_ID_BIT_DEPTH					17 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE,
#define EVERYTHING3_PROPERTY_ID_LENGTH						18 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_AUDIO_SAMPLE_RATE			19 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_AUDIO_CHANNELS				20 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_AUDIO_BITS_PER_SAMPLE		21 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_AUDIO_BIT_RATE				22 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_AUDIO_FORMAT				23 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_FILE_SIGNATURE				24 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_TITLE						25 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_ARTIST						26 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_ALBUM						27 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_YEAR						28 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_COMMENT						29 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_TRACK						30 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_GENRE						31 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_FRAME_RATE					32 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD_FIXED_Q1K,
#define EVERYTHING3_PROPERTY_ID_VIDEO_BIT_RATE				33 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_VIDEO_FORMAT				34 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_RATING						35 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE,
#define EVERYTHING3_PROPERTY_ID_TAGS						36 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_MD5							37 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_SHA1						38 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_SHA256						39 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_CRC32						40 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_SIZE_ON_DISK				41 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_DESCRIPTION					42 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_VERSION						43 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_PRODUCT_NAME				44 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_PRODUCT_VERSION				45 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_COMPANY						46 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_KIND						47 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_NAME_LENGTH					48 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_PATH_AND_NAME_LENGTH		49 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_SUBJECT						50 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_AUTHORS						51 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_DATE_TAKEN					52 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_SOFTWARE					53 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_DATE_ACQUIRED				54 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_COPYRIGHT					55 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_IMAGE_ID					56 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_HORIZONTAL_RESOLUTION		57 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_VERTICAL_RESOLUTION			58 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_COMPRESSION					59 // EVERYTHING3_PROPERTY_VALUE_TYPE_WORD,
#define EVERYTHING3_PROPERTY_ID_RESOLUTION_UNIT				60 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_COLOR_REPRESENTATION		61 // EVERYTHING3_PROPERTY_VALUE_TYPE_WORD,
#define EVERYTHING3_PROPERTY_ID_COMPRESSED_BITS_PER_PIXEL	62 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1K,
#define EVERYTHING3_PROPERTY_ID_CAMERA_MAKER				63 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CAMERA_MODEL				64 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_F_STOP						65 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1K,
#define EVERYTHING3_PROPERTY_ID_EXPOSURE_TIME				66 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1K,
#define EVERYTHING3_PROPERTY_ID_ISO_SPEED					67 // EVERYTHING3_PROPERTY_VALUE_TYPE_WORD,
#define EVERYTHING3_PROPERTY_ID_EXPOSURE_BIAS				68 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1K,
#define EVERYTHING3_PROPERTY_ID_FOCAL_LENGTH				69 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1K,
#define EVERYTHING3_PROPERTY_ID_MAX_APERTURE				70 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1M,
#define EVERYTHING3_PROPERTY_ID_METERING_MODE				71 // EVERYTHING3_PROPERTY_VALUE_TYPE_WORD,
#define EVERYTHING3_PROPERTY_ID_SUBJECT_DISTANCE			72 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1K,
#define EVERYTHING3_PROPERTY_ID_FLASH_MODE					73 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_FLASH_ENERGY				74 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1K,
#define EVERYTHING3_PROPERTY_ID_35MM_FOCAL_LENGTH			75 // EVERYTHING3_PROPERTY_VALUE_TYPE_WORD,
#define EVERYTHING3_PROPERTY_ID_LENS_MAKER					76 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_LENS_MODEL					77 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_FLASH_MAKER					78 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_FLASH_MODEL					79 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CAMERA_SERIAL_NUMBER		80 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CONTRAST					81 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_BRIGHTNESS					82 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1M,
#define EVERYTHING3_PROPERTY_ID_LIGHT_SOURCE				83 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_EXPOSURE_PROGRAM			84 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_SATURATION					85 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_SHARPNESS					86 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_WHITE_BALANCE				87 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_PHOTOMETRIC_INTERPRETATION	88 // EVERYTHING3_PROPERTY_VALUE_TYPE_WORD,
#define EVERYTHING3_PROPERTY_ID_DIGITAL_ZOOM				89 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1K,
#define EVERYTHING3_PROPERTY_ID_EXIF_VERSION				90 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_LATITUDE					91 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1M,
#define EVERYTHING3_PROPERTY_ID_LONGITUDE					92 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1M,
#define EVERYTHING3_PROPERTY_ID_ALTITUDE					93 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1M,
#define EVERYTHING3_PROPERTY_ID_SUBTITLE					94 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_TOTAL_BIT_RATE				95 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_DIRECTORS					96 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_PRODUCERS					97 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_WRITERS						98 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_PUBLISHER					99 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CONTENT_DISTRIBUTOR			100 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_DATE_ENCODED				101 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_ENCODED_BY					102 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_AUTHOR_URL					103 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_PROMOTION_URL				104 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_OFFLINE_AVAILABILITY		105 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_OFFLINE_STATUS				106 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_SHARED_WITH					107 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_OWNER						108 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_COMPUTER					109 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_ALBUM_ARTIST				110 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_PARENTAL_RATING_REASON		111 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_COMPOSER					112 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_CONDUCTOR					113 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CONTENT_GROUP_DESCRIPTION	114 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_MOOD						115 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_PART_OF_SET					116 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_INITIAL_KEY					117 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_BEATS_PER_MINUTE			118 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_PROTECTED					119 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_PART_OF_A_COMPILATION		120 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_PARENTAL_RATING				121 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_PERIOD						122 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_PEOPLE						123 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_CATEGORY					124 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_CONTENT_STATUS				125 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_DOCUMENT_CONTENT_TYPE		126 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_PAGE_COUNT					127 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_WORD_COUNT					128 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_CHARACTER_COUNT				129 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_LINE_COUNT					130 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_PARAGRAPH_COUNT				131 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_TEMPLATE					132 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_SCALE						133 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_LINKS_DIRTY					134 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_LANGUAGE					135 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_LAST_AUTHOR					136 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_REVISION_NUMBER				137 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_VERSION_NUMBER				138 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_MANAGER						139 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_DATE_CONTENT_CREATED		140 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_DATE_SAVED					141 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_DATE_PRINTED				142 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_TOTAL_EDITING_TIME			143 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_ORIGINAL_FILE_NAME			144 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_DATE_RELEASED				145 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_SLIDE_COUNT					146 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_NOTE_COUNT					147 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_HIDDEN_SLIDE_COUNT			148 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_PRESENTATION_FORMAT			149 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_TRADEMARKS					150 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_DISPLAY_NAME				151 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_NAME_LENGTH_IN_UTF8_BYTES	152 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_PATH_AND_NAME_LENGTH_IN_UTF8_BYTES	153 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_CHILD_COUNT					154 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_CHILD_FOLDER_COUNT			155 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_CHILD_FILE_COUNT			156 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_CHILD_COUNT_FROM_DISK		157 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_CHILD_FOLDER_COUNT_FROM_DISK	158 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_CHILD_FILE_COUNT_FROM_DISK	159 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DEPTH				160 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_TOTAL_SIZE					161 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_TOTAL_SIZE_ON_DISK			162 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_DATE_CHANGED				163 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_HARD_LINK_COUNT				164 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_DELETE_PENDING				165 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_IS_DIRECTORY				166 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_COUNT	167 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_NAMES	168 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_TOTAL_ALTERNATE_DATA_STREAM_SIZE	169 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_TOTAL_ALTERNATE_DATA_STREAM_SIZE_ON_DISK	170 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_COMPRESSED_SIZE				171 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_COMPRESSION_FORMAT			172 // EVERYTHING3_PROPERTY_VALUE_TYPE_WORD,
#define EVERYTHING3_PROPERTY_ID_COMPRESSION_UNIT_SHIFT		173 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE,
#define EVERYTHING3_PROPERTY_ID_COMPRESSION_CHUNK_SHIFT		174 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE,
#define EVERYTHING3_PROPERTY_ID_COMPRESSION_CLUSTER_SHIFT	175 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE,
#define EVERYTHING3_PROPERTY_ID_COMPRESSION_RATIO			176 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE,
#define EVERYTHING3_PROPERTY_ID_REPARSE_TAG					177 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_REMOTE_PROTOCOL				178 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_REMOTE_PROTOCOL_VERSION		179 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_REMOTE_PROTOCOL_FLAGS		180 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_LOGICAL_BYTES_PER_SECTOR	181 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_PHYSICAL_BYTES_PER_SECTOR_FOR_ATOMICITY	182 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_PHYSICAL_BYTES_PER_SECTOR_FOR_PERFORMANCE	183 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_EFFECTIVE_PHYSICAL_BYTES_PER_SECTOR_FOR_ATOMICITY	184 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_FILE_STORAGE_INFO_FLAGS		185 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_BYTE_OFFSET_FOR_SECTOR_ALIGNMENT	186 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_BYTE_OFFSET_FOR_PARTITION_ALIGNMENT	187 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_ALIGNMENT_REQUIREMENT		188 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_VOLUME_SERIAL_NUMBER		189 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_FILE_ID						190 // EVERYTHING3_PROPERTY_VALUE_TYPE_OWORD,
#define EVERYTHING3_PROPERTY_ID_FRAME_COUNT					191 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_CLUSTER_SIZE				192 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_SECTOR_SIZE					193 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define	EVERYTHING3_PROPERTY_ID_AVAILABLE_FREE_DISK_SIZE	194 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_FREE_DISK_SIZE				195 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_TOTAL_DISK_SIZE				196 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define _EVERYTHING3_PROPERTY_ID_UNUSED197					197 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_MAXIMUM_COMPONENT_LENGTH	198 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_FILE_SYSTEM_FLAGS			199 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_FILE_SYSTEM					200 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_ORIENTATION					201 // EVERYTHING3_PROPERTY_VALUE_TYPE_WORD,
#define EVERYTHING3_PROPERTY_ID_END_OF_FILE					202 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_SHORT_NAME					203 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_SHORT_PATH_AND_NAME			204 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_ENCRYPTION_STATUS			205 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_HARD_LINK_FILE_NAMES		206 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_INDEX_TYPE					207 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_DRIVE_TYPE					208 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_BINARY_TYPE					209 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_REGEX_MATCH_0				210 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_REGEX_MATCH_1				211 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_REGEX_MATCH_2				212 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_REGEX_MATCH_3				213 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_REGEX_MATCH_4				214 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_REGEX_MATCH_5				215 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_REGEX_MATCH_6				216 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_REGEX_MATCH_7				217 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_REGEX_MATCH_8				218 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_REGEX_MATCH_9				219 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_SIBLING_COUNT				220 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_SIBLING_FOLDER_COUNT		221 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_SIBLING_FILE_COUNT			222 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_INDEX_NUMBER				223 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_SHORTCUT_TARGET				224 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_OUT_OF_DATE					225 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_INCUR_SEEK_PENALTY			226 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_PLAIN_TEXT_LINE_COUNT		227 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_APERTURE					228 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1M,
#define EVERYTHING3_PROPERTY_ID_MAKER_NOTE					229 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_RELATED_SOUND_FILE			230 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_SHUTTER_SPEED				231 // EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1K,
#define EVERYTHING3_PROPERTY_ID_TRANSCODED_FOR_SYNC			232 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_CASE_SENSITIVE_DIR			233 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_DATE_INDEXED				234 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_NAME_FREQUENCY				235 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_SIZE_FREQUENCY				236 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_EXTENSION_FREQUENCY			237 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_REGEX_MATCHES				238 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_URL							239 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_PATH_AND_NAME				240 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_FILE_OR_FOLDER_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_PARENT_FILE_ID				241 // EVERYTHING3_PROPERTY_VALUE_TYPE_OWORD,
#define EVERYTHING3_PROPERTY_ID_SHA512						242 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_SHA384						243 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_CRC64						244 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FIRST_BYTE					245 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FIRST_2_BYTES				246 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FIRST_4_BYTES				247 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FIRST_8_BYTES				248 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FIRST_16_BYTES				249 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FIRST_32_BYTES				250 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FIRST_64_BYTES				251 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FIRST_128_BYTES				252 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_LAST_BYTE					253 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_LAST_2_BYTES				254 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_LAST_4_BYTES				255 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_LAST_8_BYTES				256 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_LAST_16_BYTES				257 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_LAST_32_BYTES				258 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_LAST_64_BYTES				259 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_LAST_128_BYTES				260 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_BYTE_ORDER_MARK				261 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_VOLUME_LABEL				262 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_FILE_LIST_PATH_AND_NAME		263 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_DISPLAY_PATH_AND_NAME		264 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_PARSE_NAME					265 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_PARSE_PATH_AND_NAME			266 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_STEM						267 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_SHELL_ATTRIBUTES			268 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_IS_FOLDER					269 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_VALID_UTF8					270 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_STEM_LENGTH					271 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_EXTENSION_LENGTH			272 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_PATH_PART_LENGTH			273 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_DATE_MODIFIED_TIME			274 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_DATE_CREATED_TIME			275 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_DATE_ACCESSED_TIME			276 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_DATE_MODIFIED_DATE			277 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_DATE_CREATED_DATE			278 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_DATE_ACCESSED_DATE			279 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_PARENT_NAME					280 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_REPARSE_TARGET				281 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_DESCENDANT_COUNT			282 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_DESCENDANT_FOLDER_COUNT		283 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_DESCENDANT_FILE_COUNT		284 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_FROM						285 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_TO							286 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_DATE_RECEIVED				287 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_DATE_SENT					288 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_CONTAINER_FILENAMES			289 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_CONTAINER_FILE_COUNT		290 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_0			291 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_1			292 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_2			293 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_3			294 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_4			295 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_5			296 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_6			297 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_7			298 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_8			299 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CUSTOM_PROPERTY_9			300 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_ALLOCATION_SIZE				301 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_SFV_CRC32					302 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_MD5SUM_MD5					303 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_SHA1SUM_SHA1				304 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_SHA256SUM_SHA256			305 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_SFV_PASS					306 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_MD5SUM_PASS					307 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_SHA1SUM_PASS				308 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_SHA256SUM_PASS				309 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_ANSI	310 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_UTF8	311 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_UTF16LE	312 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_UTF16BE	313 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_TEXT_PLAIN	314 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_ALTERNATE_DATA_STREAM_HEX	315 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_PERCEIVED_TYPE				316 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CONTENT_TYPE				317 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_OPENED_BY					318 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_TARGET_MACHINE				319 // EVERYTHING3_PROPERTY_VALUE_TYPE_WORD_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_SHA512SUM_SHA512			320 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_SHA512SUM_PASS				321 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_PARENT_PATH					322 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_FOLDER_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_FIRST_256_BYTES				323 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB16,
#define EVERYTHING3_PROPERTY_ID_FIRST_512_BYTES				324 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB16,
#define EVERYTHING3_PROPERTY_ID_LAST_256_BYTES				325 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB16,
#define EVERYTHING3_PROPERTY_ID_LAST_512_BYTES				326 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB16,
#define EVERYTHING3_PROPERTY_ID_INDEX_ONLINE				327 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_COLUMN_0					328 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_1					329 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_2					330 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_3					331 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_4					332 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_5					333 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_6					334 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_7					335 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_8					336 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_9					337 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_A					338 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_B					339 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_C					340 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_D					341 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_E					342 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_COLUMN_F					343 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_ZONE_ID						344 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_REFERRER_URL				345 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_HOST_URL					346 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_CHARACTER_ENCODING			347 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT,
#define EVERYTHING3_PROPERTY_ID_ROOT_NAME					348 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_USED_DISK_SIZE				349 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_VOLUME_PATH					350 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_MAX_CHILD_DEPTH				351 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_TOTAL_CHILD_SIZE			352 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_ROW							353 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_CHILD_OCCURRENCE_COUNT		354 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_VOLUME_NAME					355 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_DESCENDANT_OCCURRENCE_COUNT	356 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_OBJECT_ID					357 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_BIRTH_VOLUME_ID				358 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_BIRTH_OBJECT_ID				359 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_DOMAIN_ID					360 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_CRC32			361 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_CRC64			362 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_MD5				363 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_SHA1			364 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_SHA256			365 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_SHA512			366 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_CRC32	367 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_CRC64	368 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_MD5	369 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_SHA1	370 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_SHA256	371 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_SHA512	372 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_CRC32			373 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_CRC64			374 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_MD5			375 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_SHA1			376 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_SHA256			377 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_SHA512			378 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_CRC32_FROM_DISK	379 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_CRC64_FROM_DISK	380 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_MD5_FROM_DISK	381 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_SHA1_FROM_DISK	382 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_SHA256_FROM_DISK	383 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_SHA512_FROM_DISK	384 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_CRC32_FROM_DISK	385 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_CRC64_FROM_DISK	386 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_MD5_FROM_DISK	387 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_SHA1_FROM_DISK	388 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_SHA256_FROM_DISK	389 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_DATA_AND_NAMES_SHA512_FROM_DISK	390 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_CRC32_FROM_DISK	391 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_CRC64_FROM_DISK	392 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_MD5_FROM_DISK	393 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_SHA1_FROM_DISK	394 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_SHA256_FROM_DISK	395 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_FOLDER_NAMES_SHA512_FROM_DISK	396 // EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8,
#define EVERYTHING3_PROPERTY_ID_LONG_NAME					397 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_LONG_PATH_AND_NAME			398 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_DIGITAL_SIGNATURE_NAME		399 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_DIGITAL_SIGNATURE_TIMESTAMP	400 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_AUDIO_TRACK_COUNT			401 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_VIDEO_TRACK_COUNT			402 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_SUBTITLE_TRACK_COUNT		403 // EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD,
#define EVERYTHING3_PROPERTY_ID_NETWORK_INDEX_HOST			404 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE,
#define EVERYTHING3_PROPERTY_ID_ORIGINAL_LOCATION			405 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_DATE_DELETED				406 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_STATUS						407 // EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE,
#define EVERYTHING3_PROPERTY_ID_VORBIS_COMMENT				408 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_QUICKTIME_METADATA			409 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING,
#define EVERYTHING3_PROPERTY_ID_PARENT_SIZE					410 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_ROOT_SIZE					411 // EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64,
#define EVERYTHING3_PROPERTY_ID_OPENS_WITH					412 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_RANDOMIZE					413 // EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T,
#define EVERYTHING3_PROPERTY_ID_ICON						414 // EVERYTHING3_PROPERTY_VALUE_TYPE_NULL, 
#define EVERYTHING3_PROPERTY_ID_THUMBNAIL					415 // EVERYTHING3_PROPERTY_VALUE_TYPE_NULL,
#define EVERYTHING3_PROPERTY_ID_CONTENT						416 // EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING,
#define EVERYTHING3_PROPERTY_ID_SEPARATOR					417 // EVERYTHING3_PROPERTY_VALUE_TYPE_NULL,
#define EVERYTHING3_PROPERTY_ID_BUILTIN_COUNT				418 // total number of built-in properties,

// Everything3_GetResultListPropertyRequestValueType()
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_NULL								0
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE								1  // Everything3_GetResultPropertyBYTE
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_WORD								2  // Everything3_GetResultPropertyWORD
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD								3  // Everything3_GetResultPropertyDWORD
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD_FIXED_Q1K						4  // Everything3_GetResultPropertyDWORD / 1000
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_UINT64								5  // Everything3_GetResultPropertyUINT64
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_UINT128								6  // Everything3_GetResultPropertyUINT128
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_DIMENSIONS							7  // Everything3_GetResultPropertyDIMENSIONS
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING								8  // Everything3_GetResultPropertyText
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_MULTISTRING					9  // Everything3_GetResultPropertyText
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_STRING_REFERENCE			10 // Everything3_GetResultPropertyText
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_SIZE_T								11 // Everything3_GetResultPropertySIZE_T
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1K						12 // Everything3_GetResultPropertyINT32 / 1000
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_INT32_FIXED_Q1M						13 // Everything3_GetResultPropertyINT32 / 1000000
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_FOLDER_REFERENCE			14 // Everything3_GetResultPropertyText
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_PSTRING_FILE_OR_FOLDER_REFERENCE	15 // Everything3_GetResultPropertyText
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB8								16 // Everything3_GetResultPropertyBlob
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_DWORD_GET_TEXT						17 // Everything3_GetResultPropertyDWORD
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_WORD_GET_TEXT						18 // Everything3_GetResultPropertyWORD
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_BLOB16								19 // Everything3_GetResultPropertyBlob
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_BYTE_GET_TEXT						20 // Everything3_GetResultPropertyBYTE
#define	EVERYTHING3_PROPERTY_VALUE_TYPE_PROPVARIANT							21 // Everything3_GetResultPropertyPropVariant

// EVERYTHING3_PROPERTY_VALUE_TYPE_PROPVARIANT subtypes.
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_EMPTY					0
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_NULL					1
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_BYTE_UI1				2
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_WORD_UI2				3
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_DWORD_UI4				4
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_DWORD_UINT			5
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_UINT64_UI8			6
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_UINT64_FILETIME		7
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_CHAR_I1				8
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_INT16_I2				9
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_INT16_BOOL			10
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_INT32_I4				11
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_INT32_INT				12
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_INT32_ERROR			13
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_INT64_I8				14
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_INT64_CY				15
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_FLOAT_R4				16
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_DOUBLE_R8				17
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_DOUBLE_DATE			18
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_POINTER_CLSID			19
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_STRING_BSTR			20
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_STRING_LPWSTR			21
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_STRING_LPSTR			22
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_BLOB					23
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_BYTE_UI1		(128|2)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_WORD_UI2		(128|3)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_DWORD_UI4		(128|4)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_UINT64_UI8		(128|6)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_UINT64_FILETIME	(128|7)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_CHAR_I1			(128|8)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_INT16_I2		(128|9)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_INT16_BOOL		(128|10)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_INT32_I4		(128|11)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_INT32_ERROR		(128|13)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_INT64_I8		(128|14)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_INT64_CY		(128|15)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_FLOAT_R4		(128|16)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_DOUBLE_R8		(128|17)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_DOUBLE_DATE		(128|18)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_CLSID			(128|19)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_STRING_BSTR		(128|20)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_STRING_LPWSTR	(128|21)
#define EVERYTHING3_PROPERTY_VARIANT_TYPE_ARRAY_STRING_LPSTR	(128|22)

// typedefs and structs.
typedef EVERYTHING3_BYTE EVERYTHING3_UTF8;
typedef struct _everything3_client_s EVERYTHING3_CLIENT;
typedef struct _everything3_result_list_s EVERYTHING3_RESULT_LIST;
typedef struct _everything3_search_state_s EVERYTHING3_SEARCH_STATE;
typedef struct _everything3_find_handle_s EVERYTHING3_FIND_HANDLE;

typedef struct _everything3_dimensions_s
{
	EVERYTHING3_DWORD width;
	EVERYTHING3_DWORD height;
	
}EVERYTHING3_DIMENSIONS;

typedef struct _EVERYTHING3_UINT128
{
	union
	{
		struct
		{
			EVERYTHING3_UINT64 lo_uint64;
			EVERYTHING3_UINT64 hi_uint64;
		};

		struct
		{
			EVERYTHING3_DWORD lo_uint64_lo_dword;
			EVERYTHING3_DWORD lo_uint64_hi_dword;
			EVERYTHING3_DWORD hi_uint64_lo_dword;
			EVERYTHING3_DWORD hi_uint64_hi_dword;
		};
	};
	
}EVERYTHING3_UINT128;

// retrieve the last error for the current thread.
// can return EVERYTHING3_OK or one of the EVERYTHING3_ERROR_* types.
// wrapper for GetLastError();
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetLastError(void);

// Connect to Everything
// instance name can be NULL or an empty string to connect to the main unnamed instance.
EVERYTHING3_USERAPI EVERYTHING3_CLIENT *EVERYTHING3_API Everything3_ConnectUTF8(const EVERYTHING3_UTF8 *instance_name);
EVERYTHING3_USERAPI EVERYTHING3_CLIENT *EVERYTHING3_API Everything3_ConnectW(const EVERYTHING3_WCHAR *instance_name);
EVERYTHING3_USERAPI EVERYTHING3_CLIENT *EVERYTHING3_API Everything3_ConnectA(const EVERYTHING3_CHAR *instance_name);

// cancels all pending requests.
// causes any blocking calls to return immediately.
// no more commands can be issued to this client after shutting down.
// can be called from any thread.
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_ShutdownClient(EVERYTHING3_CLIENT *client);

// Destroy an Everything client.
// disconnects from everything and frees any resources back to the system.
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_DestroyClient(EVERYTHING3_CLIENT *client);

// general
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetIPCPipeVersion(EVERYTHING3_CLIENT *client);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetMajorVersion(EVERYTHING3_CLIENT *client);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetMinorVersion(EVERYTHING3_CLIENT *client);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetRevision(EVERYTHING3_CLIENT *client);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetBuildNumber(EVERYTHING3_CLIENT *client);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything_GetTargetMachine(EVERYTHING3_CLIENT *client);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_IsDBLoaded(EVERYTHING3_CLIENT *client);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetRunCountFromFilenameUTF8(EVERYTHING3_CLIENT *client,const EVERYTHING3_UTF8 *lpFilename);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetRunCountFromFilenameW(EVERYTHING3_CLIENT *client,const EVERYTHING3_WCHAR *lpFilename);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetRunCountFromFilenameA(EVERYTHING3_CLIENT *client,const EVERYTHING3_CHAR *lpFilename);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetRunCountFromFilenameUTF8(EVERYTHING3_CLIENT *client,const EVERYTHING3_UTF8 *lpFilename,EVERYTHING3_DWORD dwRunCount);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetRunCountFromFilenameW(EVERYTHING3_CLIENT *client,const EVERYTHING3_WCHAR *lpFilename,EVERYTHING3_DWORD dwRunCount);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetRunCountFromFilenameA(EVERYTHING3_CLIENT *client,const EVERYTHING3_CHAR *lpFilename,EVERYTHING3_DWORD dwRunCount);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_IncRunCountFromFilenameUTF8(EVERYTHING3_CLIENT *client,const EVERYTHING3_UTF8 *lpFilename);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_IncRunCountFromFilenameW(EVERYTHING3_CLIENT *client,const EVERYTHING3_WCHAR *lpFilename);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_IncRunCountFromFilenameA(EVERYTHING3_CLIENT *client,const EVERYTHING3_CHAR *lpFilename);
EVERYTHING3_USERAPI EVERYTHING3_UINT64 EVERYTHING3_API Everything3_GetFolderSizeFromFilenameUTF8(EVERYTHING3_CLIENT *client,const EVERYTHING3_UTF8 *lpFilename);
EVERYTHING3_USERAPI EVERYTHING3_UINT64 EVERYTHING3_API Everything3_GetFolderSizeFromFilenameW(EVERYTHING3_CLIENT *client,const EVERYTHING3_WCHAR *lpFilename);
EVERYTHING3_USERAPI EVERYTHING3_UINT64 EVERYTHING3_API Everything3_GetFolderSizeFromFilenameA(EVERYTHING3_CLIENT *client,const EVERYTHING3_CHAR *lpFilename);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetFileAttributesExW(EVERYTHING3_CLIENT *client,const EVERYTHING3_WCHAR *lpFilename,WIN32_FIND_DATAW *pfd);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetFileAttributesExA(EVERYTHING3_CLIENT *client,const EVERYTHING3_CHAR *lpFilename,WIN32_FIND_DATAA *pfd);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetFileAttributesUTF8(EVERYTHING3_CLIENT *client,const EVERYTHING3_UTF8 *lpFilename);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetFileAttributesW(EVERYTHING3_CLIENT *client,const EVERYTHING3_WCHAR *lpFilename);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetFileAttributesA(EVERYTHING3_CLIENT *client,const EVERYTHING3_CHAR *lpFilename);
EVERYTHING3_USERAPI EVERYTHING3_FIND_HANDLE *EVERYTHING3_API Everything3_FindFirstFileW(EVERYTHING3_CLIENT *client,const EVERYTHING3_WCHAR *lpFilename,WIN32_FIND_DATAW *pfd);
EVERYTHING3_USERAPI EVERYTHING3_FIND_HANDLE *EVERYTHING3_API Everything3_FindFirstFileA(EVERYTHING3_CLIENT *client,const EVERYTHING3_CHAR *lpFilename,WIN32_FIND_DATAA *pfd);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_FindNextFileW(EVERYTHING3_FIND_HANDLE *find_handle,WIN32_FIND_DATAW *pfd);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_FindNextFileA(EVERYTHING3_FIND_HANDLE *find_handle,WIN32_FIND_DATAA *pfd);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_FindClose(EVERYTHING3_FIND_HANDLE *find_handle);

// Find Properties and get property information
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_FindPropertyUTF8(EVERYTHING3_CLIENT *client,const EVERYTHING3_UTF8 *canonical_name);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_FindPropertyW(EVERYTHING3_CLIENT *client,const EVERYTHING3_WCHAR *canonical_name);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_FindPropertyA(EVERYTHING3_CLIENT *client,const EVERYTHING3_CHAR *canonical_name);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetPropertyNameUTF8(EVERYTHING3_CLIENT *client,EVERYTHING3_DWORD property_id,EVERYTHING3_UTF8 *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetPropertyNameW(EVERYTHING3_CLIENT *client,EVERYTHING3_DWORD property_id,EVERYTHING3_WCHAR *wbuf,EVERYTHING3_SIZE_T wbuf_size_in_wchars);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetPropertyNameA(EVERYTHING3_CLIENT *client,EVERYTHING3_DWORD property_id,EVERYTHING3_CHAR *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetPropertyCanonicalNameUTF8(EVERYTHING3_CLIENT *client,EVERYTHING3_DWORD property_id,EVERYTHING3_UTF8 *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetPropertyCanonicalNameW(EVERYTHING3_CLIENT *client,EVERYTHING3_DWORD property_id,EVERYTHING3_WCHAR *wbuf,EVERYTHING3_SIZE_T wbuf_size_in_wchars);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetPropertyCanonicalNameA(EVERYTHING3_CLIENT *client,EVERYTHING3_DWORD property_id,EVERYTHING3_CHAR *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetPropertyType(EVERYTHING3_CLIENT *client,EVERYTHING3_DWORD property_id);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_IsPropertyIndexed(EVERYTHING3_CLIENT *client,EVERYTHING3_DWORD property_id);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_IsPropertyFastSort(EVERYTHING3_CLIENT *client,EVERYTHING3_DWORD property_id);

// Setup the search state.
EVERYTHING3_USERAPI EVERYTHING3_SEARCH_STATE *EVERYTHING3_API Everything3_CreateSearchState(void);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_DestroySearchState(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchMatchCase(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_BOOL match_case);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchMatchDiacritics(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_BOOL match_diacritics);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchMatchWholeWords(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_BOOL match_whole_words);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchMatchPath(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_BOOL match_path);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchMatchPrefix(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_BOOL match_prefix);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchMatchSuffix(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_BOOL match_suffix);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchIgnorePunctuation(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_BOOL ignore_punctuation);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchWhitespace(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_BOOL ignore_whitespace);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchRegex(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_BOOL match_regex);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchFoldersFirst(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_DWORD folders_first_type);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchRequestTotalSize(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_BOOL request_total_size);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchHideResultOmissions(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_BOOL hide_result_omissions);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchSortMix(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_BOOL sort_mix);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchTextUTF8(EVERYTHING3_SEARCH_STATE *search_state,const EVERYTHING3_UTF8 *search);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchTextW(EVERYTHING3_SEARCH_STATE *search_state,const EVERYTHING3_WCHAR *search);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchTextA(EVERYTHING3_SEARCH_STATE *search_state,const EVERYTHING3_CHAR *search);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_AddSearchSort(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_DWORD property_id,EVERYTHING3_BOOL ascending);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_ClearSearchSorts(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_AddSearchPropertyRequest(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_DWORD property_id);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_AddSearchPropertyRequestFormatted(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_DWORD property_id);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_AddSearchPropertyRequestHighlighted(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_DWORD property_id);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_ClearSearchPropertyRequests(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchViewportOffset(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_SIZE_T offset);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_SetSearchViewportCount(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_SIZE_T count);

// Get the search state.
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchMatchCase(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchMatchDiacritics(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchMatchWholeWords(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchMatchPath(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchMatchPrefix(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchMatchSuffix(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchIgnorePunctuation(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchWhitespace(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchRegex(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetSearchFoldersFirst(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchRequestTotalSize(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchHideResultOmissions(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchSortMix(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetSearchTextUTF8(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_UTF8 *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetSearchTextW(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_WCHAR *wbuf,EVERYTHING3_SIZE_T wbuf_size_in_wchars);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetSearchTextA(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_CHAR *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetSearchSortCount(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetSearchSortPropertyId(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_SIZE_T sort_index);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchSortAscending(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_SIZE_T sort_index);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetSearchPropertyRequestCount(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetSearchPropertyRequestPropertyId(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_SIZE_T index);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchPropertyRequestHighlight(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_SIZE_T index);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetSearchPropertyRequestFormat(EVERYTHING3_SEARCH_STATE *search_state,EVERYTHING3_SIZE_T index);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetSearchViewportOffset(EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetSearchViewportCount(EVERYTHING3_SEARCH_STATE *search_state);

// execute a search
EVERYTHING3_USERAPI EVERYTHING3_RESULT_LIST *EVERYTHING3_API Everything3_Search(EVERYTHING3_CLIENT *client,EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_RESULT_LIST *EVERYTHING3_API Everything3_GetResults(EVERYTHING3_CLIENT *client,EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_RESULT_LIST *EVERYTHING3_API Everything3_Sort(EVERYTHING3_CLIENT *client,EVERYTHING3_SEARCH_STATE *search_state);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_IsResultListChange(EVERYTHING3_CLIENT *client); 
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_WaitForResultListChange(EVERYTHING3_CLIENT *client);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_DestroyResultList(EVERYTHING3_RESULT_LIST *result_list);

// Result list.
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultListFolderCount(const EVERYTHING3_RESULT_LIST *result_list);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultListFileCount(const EVERYTHING3_RESULT_LIST *result_list);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultListCount(const EVERYTHING3_RESULT_LIST *result_list);
EVERYTHING3_USERAPI EVERYTHING3_UINT64 EVERYTHING3_API Everything3_GetResultListTotalSize(const EVERYTHING3_RESULT_LIST *result_list);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultListViewportOffset(const EVERYTHING3_RESULT_LIST *result_list);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultListViewportCount(const EVERYTHING3_RESULT_LIST *result_list);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultListSortCount(const EVERYTHING3_RESULT_LIST *result_list);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetResultListSortPropertyId(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T sort_index);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetResultListSortAscending(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T sort_index);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultListPropertyRequestCount(const EVERYTHING3_RESULT_LIST *result_list);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetResultListPropertyRequestPropertyId(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T property_index);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetResultListPropertyRequestValueType(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T property_index);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultListPropertyRequestOffset(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T property_index);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_IsFolderResult(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_IsRootResult(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultPropertyTextUTF8(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id,EVERYTHING3_UTF8 *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultPropertyTextW(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id,EVERYTHING3_WCHAR *wbuf,EVERYTHING3_SIZE_T wbuf_size_in_wchars);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultPropertyTextA(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id,EVERYTHING3_CHAR *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultPropertyTextFormattedUTF8(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id,EVERYTHING3_UTF8 *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultPropertyTextFormattedW(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id,EVERYTHING3_WCHAR *wbuf,EVERYTHING3_SIZE_T wbuf_size_in_wchars);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultPropertyTextFormattedA(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id,EVERYTHING3_CHAR *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultPropertyTextHighlightedUTF8(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id,EVERYTHING3_UTF8 *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultPropertyTextHighlightedW(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id,EVERYTHING3_WCHAR *wbuf,EVERYTHING3_SIZE_T wbuf_size_in_wchars);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultPropertyTextHighlightedA(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id,EVERYTHING3_CHAR *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_BYTE EVERYTHING3_API Everything3_GetResultPropertyBYTE(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id);
EVERYTHING3_USERAPI EVERYTHING3_WORD EVERYTHING3_API Everything3_GetResultPropertyWORD(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetResultPropertyDWORD(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id);
EVERYTHING3_USERAPI EVERYTHING3_UINT64 EVERYTHING3_API Everything3_GetResultPropertyUINT64(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetResultPropertyUINT128(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id,EVERYTHING3_UINT128 *puint128);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetResultPropertyDIMENSIONS(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id,EVERYTHING3_DIMENSIONS *dimensions);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultPropertySIZE_T(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id);
EVERYTHING3_USERAPI EVERYTHING3_INT32 EVERYTHING3_API Everything3_GetResultPropertyINT32(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id);
EVERYTHING3_USERAPI EVERYTHING3_BOOL EVERYTHING3_API Everything3_GetResultPropertyBlob(const EVERYTHING3_RESULT_LIST *result_list,SIZE_T result_index,EVERYTHING3_DWORD property_id,EVERYTHING3_BYTE *buf,SIZE_T *pbufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultNameUTF8(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_UTF8 *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultNameW(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_WCHAR *wbuf,EVERYTHING3_SIZE_T wbuf_size_in_wchars);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultNameA(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_CHAR *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultPathUTF8(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_UTF8 *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultPathW(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_WCHAR *wbuf,EVERYTHING3_SIZE_T wbuf_size_in_wchars);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultPathA(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_CHAR *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultFullPathNameUTF8(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_UTF8 *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultFullPathNameW(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_WCHAR *wbuf,EVERYTHING3_SIZE_T wbuf_size_in_wchars);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultFullPathNameA(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_CHAR *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_UINT64 EVERYTHING3_API Everything3_GetResultSize(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultExtensionUTF8(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_UTF8 *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultExtensionW(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_WCHAR *wbuf,EVERYTHING3_SIZE_T wbuf_size_in_wchars);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultExtensionA(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_CHAR *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultTypeUTF8(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_UTF8 *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultTypeW(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_WCHAR *wbuf,EVERYTHING3_SIZE_T wbuf_size_in_wchars);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultTypeA(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_CHAR *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_UINT64 EVERYTHING3_API Everything3_GetResultDateModified(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index);
EVERYTHING3_USERAPI EVERYTHING3_UINT64 EVERYTHING3_API Everything3_GetResultDateCreated(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index);
EVERYTHING3_USERAPI EVERYTHING3_UINT64 EVERYTHING3_API Everything3_GetResultDateAccessed(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetResultAttributes(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index);
EVERYTHING3_USERAPI EVERYTHING3_UINT64 EVERYTHING3_API Everything3_GetResultDateRecentlyChanged(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index);
EVERYTHING3_USERAPI EVERYTHING3_DWORD EVERYTHING3_API Everything3_GetResultRunCount(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index);
EVERYTHING3_USERAPI EVERYTHING3_UINT64 EVERYTHING3_API Everything3_GetResultDateRun(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultFilelistFilenameUTF8(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_UTF8 *buf,EVERYTHING3_SIZE_T bufsize);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultFilelistFilenameW(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_WCHAR *wbuf,EVERYTHING3_SIZE_T wbuf_size_in_wchars);
EVERYTHING3_USERAPI EVERYTHING3_SIZE_T EVERYTHING3_API Everything3_GetResultFilelistFilenameA(const EVERYTHING3_RESULT_LIST *result_list,EVERYTHING3_SIZE_T result_index,EVERYTHING3_CHAR *buf,EVERYTHING3_SIZE_T bufsize);

#ifdef UNICODE
#define Everything3_Connect Everything3_ConnectW
#define Everything3_FindProperty Everything3_FindPropertyW
#define Everything3_GetPropertyName Everything3_GetPropertyNameW
#define Everything3_GetPropertyCanonicalName Everything3_GetPropertyCanonicalNameW
#define Everything3_SetSearchText Everything3_SetSearchTextW
#define Everything3_GetSearchText Everything3_GetSearchTextW
#define Everything3_GetResultPropertyText Everything3_GetResultPropertyTextW
#define Everything3_GetResultPropertyTextFormatted Everything3_GetResultPropertyTextFormattedW
#define Everything3_GetResultPropertyTextHighlighted Everything3_GetResultPropertyTextHighlightedW
#define Everything3_GetResultName Everything3_GetResultNameW
#define Everything3_GetResultPath Everything3_GetResultPathW
#define Everything3_GetResultFullPathName Everything3_GetResultFullPathNameW
#define Everything3_GetResultExtension Everything3_GetResultExtensionW
#define Everything3_GetResultType Everything3_GetResultTypeW
#define Everything3_GetResultFilelistFilename Everything3_GetResultFilelistFilenameW
#define Everything3_GetRunCountFromFilename Everything3_GetRunCountFromFilenameW
#define Everything3_SetRunCountFromFilename Everything3_SetRunCountFromFilenameW
#define Everything3_IncRunCountFromFilename Everything3_IncRunCountFromFilenameW
#define Everything3_GetFolderSizeFromFilename Everything3_GetFolderSizeFromFilenameW
#define Everything3_GetFileAttributesEx Everything3_GetFileAttributesExW
#define Everything3_GetFileAttributes Everything3_GetFileAttributesW
#define Everything3_FindFirstFile Everything3_FindFirstFileW
#define Everything3_FindNextFile Everything3_FindNextFileW
#else
#define Everything3_Connect Everything3_ConnectA
#define Everything3_FindProperty Everything3_FindPropertyA
#define Everything3_GetPropertyName Everything3_GetPropertyNameA
#define Everything3_GetPropertyCanonicalName Everything3_GetPropertyCanonicalNameA
#define Everything3_SetSearchText Everything3_SetSearchTextA
#define Everything3_GetSearchText Everything3_GetSearchTextA
#define Everything3_GetResultPropertyText Everything3_GetResultPropertyTextA
#define Everything3_GetResultPropertyTextFormatted Everything3_GetResultPropertyTextFormattedA
#define Everything3_GetResultPropertyTextHighlighted Everything3_GetResultPropertyTextHighlightedA
#define Everything3_GetResultName Everything3_GetResultNameA
#define Everything3_GetResultPath Everything3_GetResultPathA
#define Everything3_GetResultFullPathName Everything3_GetResultFullPathNameA
#define Everything3_GetResultExtension Everything3_GetResultExtensionA
#define Everything3_GetResultType Everything3_GetResultTypeA
#define Everything3_GetResultFilelistFilename Everything3_GetResultFilelistFilenameA
#define Everything3_GetRunCountFromFilename Everything3_GetRunCountFromFilenameA
#define Everything3_SetRunCountFromFilename Everything3_SetRunCountFromFilenameA
#define Everything3_IncRunCountFromFilename Everything3_IncRunCountFromFilenameA
#define Everything3_GetFolderSizeFromFilename Everything3_GetFolderSizeFromFilenameA
#define Everything3_GetFileAttributesEx Everything3_GetFileAttributesExA
#define Everything3_GetFileAttributes Everything3_GetFileAttributesA
#define Everything3_FindFirstFile Everything3_FindFirstFileA
#define Everything3_FindNextFile Everything3_FindNextFileA
#endif

#ifdef __cplusplus
}
#endif

#endif // _EVERYTHING3_H_

